/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2004 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "qhaccjrnlchsr.h"
#include "qhacc.h"
#include "copystore.h"
#include "qhaccutils.h"
#include "qhacctable.h"
#include "qhaccjrnlchsr.moc"

QHaccJournalChooser::QHaccJournalChooser( QHacc * eng, QWidget * p,
																					const char * c ) : QTabBar( p, c ){
	ids=new int[0];
	engine=eng;
	setAcceptDrops( true );
}

QHaccJournalChooser::~QHaccJournalChooser(){}

void QHaccJournalChooser::save() const {
	engine->setIP( "JOURNALINDEX", currentTab() );
}

void QHaccJournalChooser::readPrefs( bool initial ) {
	if( initial ){
		connect( engine, SIGNAL( addedL( const Journal& ) ),
						 SLOT( addL( const Journal& ) ) );
		connect( engine, SIGNAL( removedL( const Journal& ) ),
						 SLOT( remL( const Journal& ) ) );
		connect( engine, SIGNAL( updatedL( const Journal&, const Journal& ) ),
						 this, SLOT( updL( const Journal&, const Journal& ) ) );
		connect( this, SIGNAL( selected( int ) ), SLOT( changeJournal( int ) ) );
	}

	// upon changing QHACC_HOME, all the journals need to be refreshed
	uint lim=count();
	for( uint i=0; i<lim; i++ ) removeTab( tab( ids[i] ) );
	delete [] ids;
	ids=new int[0];

	// now, readd the journals
	auto_ptr<QHaccResultSet> ledgs=engine->getLs();
	for( uint i=0; i<ledgs->rows(); i++ ) addL( ledgs->at( i ) );

	int li=engine->getIP( "JOURNALINDEX" );
	if( li>=count() ) li=0; // sanity check of (possibly) user-edited files
	setCurrentTab( ids[li] );
	changeJournal( ids[li] );
}

void QHaccJournalChooser::changeJournal( int i ){
	QTab * t=tab( i );

	std::ostream * str=0;
	if( Utils::debug( Utils::CURIOSITY, str ) )
		*str<<"changed journal to "<<t->text()<<endl;
	save();

	emit changedJournal( engine->getL( t->text() ) );
}

void QHaccJournalChooser::addL( const Journal& l ){
	int lim=count();
	int * newids=new int[lim+1];
	for( int i=0; i<lim; i++ ) newids[i]=ids[i];
	delete [] ids;
	ids=newids;

	QTab * t=new QTab( "" );
	ids[lim]=addTab( t );
	// tabbar doesn't refresh automatically (?), so force a refresh
	t->setText( l.gets( QC::LNAME ) );
}

void QHaccJournalChooser::remL( const Journal& l ){
	QTab * t=getLTab( l ); // tab to remove
	int id=t->identifier();
	int lim=count(), cur=0;
	int * newids=new int[lim-1];
	removeTab( t );

	for( int i=0; i<lim; i++ )	if( ids[i]!=id ) newids[cur++]=ids[i];
	delete [] ids;
	ids=newids;
	setCurrentTab( ids[0] );
	changeJournal( ids[0] );
}

void QHaccJournalChooser::updL( const Journal& older, const Journal& newer ){
	if( older[QC::LNAME]!=newer[QC::LNAME] ){
		QTab * t=getLTab( older );
		t->setText( newer.gets( QC::LNAME ) );
	}
}

QTab * QHaccJournalChooser::getLTab( const Journal& l ) const {
	int lim=count();
	for( int i=0; i<lim; i++ ){
		QTab * t=tab( ids[i] );
		if( l[QC::LNAME]==t->text() ) return t;
	}
	return 0;
}

Journal QHaccJournalChooser::getSelected() const {
	if( currentTab()>-1 ) return engine->getL( tab( currentTab() )->text() );
	return Journal();
}

void QHaccJournalChooser::dragEnterEvent( QDragEnterEvent * e ){
	if( QHaccTDrag::canDecode( e ) ) e->accept();
}

void QHaccJournalChooser::dropEvent( QDropEvent * e ){
	Transaction t;
	QHaccTable s;
	uint a=0;
	if( QHaccTDrag::decode( e, t, s, a ) ){
		QTab * mytab=selectTab( e->pos() );
		if( mytab ){
			Journal l=engine->getL( mytab->text() );

			t.set( QC::TLID, l[QC::LID] );
			engine->updateT( t, s );
		}
	}
}
