/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2004 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
*************************** * * * * * * * * * * * * **************************/

#ifndef _QHACCPREFDLG_H
#define _QHACCPREFDLG_H

#include "qhacctablerows.h"

#include <qframe.h>
#include <qdialog.h>
#include <qtabdialog.h>

#include <vector>
using namespace std;

class QHacc;
class QHaccLineEdit;
class QHaccResultSet;
class QHaccChoiceEdit;
class QHaccPluginPrefsWidget;

class QLabel;
class QComboBox;
class QCheckBox;
class QLineEdit;
class QCheckBox;
class QGridLayout;
class QPushButton;
class QButtonGroup;
class QRadioButton;

/********************************************/
/*********** PrefsDlg definitions ***********/
/********************************************/
class QHaccPrefsWidget : public QWidget {
  Q_OBJECT
    public:
  QHaccPrefsWidget ( QHacc * engine, QWidget * =0, const char * =0 );
  ~QHaccPrefsWidget();
	void accept();
	
  protected slots:
		void mColor();
  void aColor();
  void cFont();
	
 private:
	QHacc * engine;
  QPushButton * mbtn, * abtn, * fbtn;
  QLineEdit * symbol, * sep, * title, * currseper;
  QButtonGroup * liner, * dater;
  QComboBox * autocomps;
  QCheckBox * igcase, * showrec, * gtypeahead, * hideleds;
	QCheckBox * showanums, * useanums, * recjournals;
  QFont fonter;
};

class QHaccGraphPrefsWidget : public QWidget {
	Q_OBJECT
		public:
	QHaccGraphPrefsWidget( QHacc * engine, QWidget * =0, const char * =0 );
	~QHaccGraphPrefsWidget();
	void accept();
	
 private:
	QHacc * engine;
	QButtonGroup * grapher, * reporter;
	QLineEdit * grtime;
	QHaccPluginPrefsWidget * plugins;
};

class QHaccOtherPrefsWidget : public QWidget {
  Q_OBJECT
    public:
  QHaccOtherPrefsWidget ( QHacc * engine, QWidget * =0, const char * =0 );
  ~QHaccOtherPrefsWidget();
	void accept();
	
 private:
	QHacc * engine;
	QPushButton * defAcct;
	QCheckBox * simpleFD, * maintbal, * autosave, * altcurrency, * rollup;
	QLineEdit * altsymbol, * altfactor;

	public slots:
		void modAcct();
};

class QHaccPluginPrefsWidget : public QWidget {
  Q_OBJECT
    public:
  QHaccPluginPrefsWidget ( QHacc * engine, vector<int> types, 
													 QWidget * =0, const char * =0 );
  ~QHaccPluginPrefsWidget();
	void accept();
	
 private:
	QHacc * engine;
	QHaccResultSet * pimap;
	QWidget ** widgets;
};

class PrefsDlg : public QTabDialog {
	Q_OBJECT
		public:
	PrefsDlg( QHacc * engine, int, QWidget * =0, const char * =0 );
	~PrefsDlg();
	
	protected slots:
		void accept();
	
 private:
	QHacc * engine;
	QHaccPrefsWidget * tab1;
	QHaccGraphPrefsWidget * tab2;
	QHaccOtherPrefsWidget * tab3;
	QHaccPluginPrefsWidget * tab4;
};

#endif
