/*
    This file is part of Kismet

    Kismet is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Kismet is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Kismet; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * Cache files for gpsmap to cache preparsed XML
*/

#ifndef __GPSMAP_CACHE_H__
#define __GPSMAP_CACHE_H__

#include "config.h"

#include <algorithm>
#include <string>
#include <vector>
#include <map>

#ifdef HAVE_LIBZ
#include <zlib.h>
#endif

#include "gpsdump.h"
#include "expat.h"

// Caches are only meant to be used on the system they were cached
// on, so we don't use special data sizes

#define GPSCACHE_DIR       ".gpsmap"
#define GPSCACHE_SUFFIX    ".cache"
#define GPSCACHE_MAGIC      0x474B434D
#define GPSCACHE_VERSION    1

// Struct in host-endian format for cache header
typedef struct {
    // Magic value
    uint32_t cache_magic;
    // Version of cache
    uint8_t cache_version;
    // Lastmod of file this is a cache of
    time_t gps_last_mod;
    // Number of networks to read
    uint32_t num_networks;
    uint32_t num_points;
} gpscache_header;

// host-endian information about a network after parsing
typedef struct {
    uint8_t type;
    uint8_t bssid[6];
    char ssid[32];
    char beacon_info[256];
    int llc_packets, data_packets, crypt_packets, interesting_packets;
    int channel;
    short int wep;
    time_t last_time;
    time_t first_time;
    int beacon;
    int carrier_set, encoding_set;
    short int range_ip[4];
    long int data_size;
    // None of the other stuff is used by gpsmap, or its generated by gpsmap
    // based on the samples collected.
} gpscache_network;

// host-endian information about a sample point
typedef struct {
    char bssid[MAC_STR_LEN];
    char source[MAC_STR_LEN];
    uint64_t tv_sec;
    uint64_t tv_usec;
    float lat, lon, alt, spd, heading;
    int fix;
    int signal, noise;
} gpscache_point;

// Read a cache from a file
int ReadGpsCacheFile(const char *in_gpsfname, 
                     vector<wireless_network *> *in_networklist,
                     vector<gps_point *> *in_points);

// Cache gps data to a file
int WriteGpsCacheFile(const char *in_gpsfname,
                      vector<wireless_network *> *in_networklist,
                      vector<gps_point *> *in_points);

#endif

