/***************************************************************************
                          calc.cpp  -  description
                             -------------------
    begin                : Thu Jul 20 2000
    copyright            : (C) 2000 by Helmut Steger
    email                : hel.steger@rolmail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "calc.h"


calculation::calculation ()
{
}


calculation::~calculation()
{
}


void calculation::setInfo (void *crbuf, void *cibuf,ITER *maxit)
{
	crbuffer=crbuf;
	cibuffer=cibuf;
	maxiter=maxit;
}


void calculation::setJuliaConst (long double r, long double i)
{
	julia_rconst=r;
	julia_iconst=i;
}


ITER calculation::calcPoint (int x, int y)
{
	float i,r,cr,ci,zr,zi;
	ITER iter=1;
	
	//cr=rmin+dx*(FLT)x;
	//ci=imin+dy*(FLT)y;
	cr=((float *)crbuffer)[x];
	ci=((float *)cibuffer)[y];

	// eine Iteration berspringen
	zi=-ci;
	zr=-cr;

	while ( iter < *maxiter && ( (zr*zr+zi*zi) < 4.0) )
	{
		i=zi; r=zr;
		zi=(i+i)*r-ci;
		zr=r*r-i*i-cr;
		iter++;
	}
	return iter;
}


long double calculation::getCr (int x)
{
	float cr=((float *)crbuffer)[x];
	return (long double)cr;
}


long double calculation::getCi (int y)
{
	float ci=((float *)cibuffer)[y];
	return (long double)ci;
}


ITER calculation_Double::calcPoint (int x, int y)
{
	double i,r,cr,ci,zr,zi;
	ITER iter=1;
	
	//cr=rmin+dx*(FLT)x;
	//ci=imin+dy*(FLT)y;
	cr=((double *)crbuffer)[x];
	ci=((double *)cibuffer)[y];

	// eine Iteration berspringen
	zi=-ci;
	zr=-cr;

	while ( iter < *maxiter && ( (zr*zr+zi*zi) < 4.0) )
	{
		i=zi; r=zr;
		zi=(i+i)*r-ci;
		zr=r*r-i*i-cr;
		iter++;
	}
	return iter;
}


long double calculation_Double::getCr (int x)
{
	double cr=((double *)crbuffer)[x];
	return (long double)cr;
}


long double calculation_Double::getCi (int y)
{
	double ci=((double *)cibuffer)[y];
	return (long double)ci;
}


ITER calculation_LongDouble::calcPoint (int x, int y)
{
	long double i,r,cr,ci,zr,zi;
	ITER iter=1;
	
	//cr=rmin+dx*(FLT)x;
	//ci=imin+dy*(FLT)y;
	cr=((long double *)crbuffer)[x];
	ci=((long double *)cibuffer)[y];
	
	// eine Iteration berspringen
	zi=-ci;
	zr=-cr;

	while ( iter < *maxiter && ( (zr*zr+zi*zi) < 4.0) )
	{
		i=zi; r=zr;
		zi=(i+i)*r-ci;
		zr=r*r-i*i-cr;
		iter++;
	}
	return iter;
}


long double calculation_LongDouble::getCr (int x)
{
	long double cr=((long double *)crbuffer)[x];
	return cr;
}


long double calculation_LongDouble::getCi (int y)
{
	long double ci=((long double *)cibuffer)[y];
	return ci;
}


ITER calculation_Julia::calcPoint (int x, int y)
{
	long double zr,zi,ztemp;
	ITER iter=0;
	
	zr=((long double *)crbuffer)[x];
	zi=((long double *)cibuffer)[y];
	while ( iter < *maxiter && ( (zr*zr+zi*zi) < 100.0) )
	{
		ztemp=zr*zr-zi*zi+julia_rconst;
		zi=(zr+zr)*zi+julia_iconst;
		zr=ztemp;
		iter++;
	}
	return iter;
}
