/***************************************************************************
                          misc.h  -  description
                             -------------------
    begin                : Fri Jun 23 2000
    copyright            : (C) 2000 by Helmut Steger
    email                : hel.steger@rolmail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MISC_H
#define MISC_H

#include <ctype.h>
#include <qcheckbox.h>
#include "kisomandel.h"

typedef long double	PREFVAL;
#define	PREFVAL_FMT	"%llf"

struct Prefs
{
	char *token;
	PREFVAL num_value;
	char *str_value;
	short str_maxlen;
	bool valid;
};

struct palRgb
{
	unsigned short r;
	unsigned short g;
	unsigned short b;
};


class fractal;
extern QColor *colorpalette[];
extern QColor *colorpalette_bright[];
extern QColor *colorpalette_dark[];

extern palRgb colors_rgb[];


void initPalette (int maxiter, bool loaded=false);
void createPal (unsigned short index, unsigned short r, unsigned short g, unsigned short b);
int validRotate (int grad);
int desktopWidth();
int desktopHeight();
int min (int a, int b);
int max (int a, int b);
int CalcDeg10 (float g);
int angle10 (int cx, int cy, int x, int y);
void lowercase (char *s);
void fnum2str (long double n, QString &s, unsigned short maxdecimals=0);
short getChecked (QCheckBox *cb);

bool prefsSetTokenValue (struct Prefs p[], const char *token, PREFVAL value);
bool prefsSetTokenValue (struct Prefs p[], const char *token, char *s);
bool prefsGetTokenValue (struct Prefs p[], const char *token, PREFVAL &value);
bool prefsGetTokenValue (struct Prefs p[], const char *token, char *s);

#endif
