/***************************************************************************
                          calc.h  -  description
                             -------------------
    begin                : Thu Jul 20 2000
    copyright            : (C) 2000 by Helmut Steger
    email                : hel.steger@rolmail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CALC_H
#define CALC_H


#include <math.h>
#include "kisomandel.h"

/**
  *@author Helmut Steger
  */

typedef unsigned short ITER;


class calculation
{
	public:
		calculation ();
		virtual ~calculation();
		virtual ITER calcPoint (int x, int y);
		virtual long double getCr (int x);
		virtual long double getCi (int y);
		void setInfo (void *crbuf, void *cibuf,ITER *maxit);
		void setJuliaConst (long double r, long double i);		
	protected:
		ITER *maxiter;
		void *crbuffer;
		void *cibuffer;
		long double julia_rconst;
		long double julia_iconst;
};


class calculation_Double : public calculation
{
	public:
		virtual ITER calcPoint (int x, int y);
		virtual long double getCr (int x);
		virtual long double getCi (int y);
};


class calculation_LongDouble : public calculation
{
	public:
		virtual ITER calcPoint (int x, int y);
		virtual long double getCr (int x);
		virtual long double getCi (int y);
};


class calculation_Julia : public calculation_LongDouble
{
	public:
		virtual ITER calcPoint (int x, int y);
};


#endif
