/***************************************************************************
                          fractal.h  -  description
                             -------------------
    begin                : Fri Jun 23 2000
    copyright            : (C) 2000 by Helmut Steger
    email                : hel.steger@rolmail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FRACTAL_H
#define FRACTAL_H

#include <qwidget.h>
#include "kisomandel.h"
#include "calc.h"

/**
  *@author Helmut Steger
  */

#define FRACT_MINWIDTH		100
#define FRACT_MAXWIDTH		4096
#define FRACT_MINHEIGHT		100
#define FRACT_MAXHEIGHT		4096
#define MIN_ITER			64
#define MAX_ITER			10000
#define DEFAULT_ITER		64
#define AREA_BUTTOM			(MAX_ITER)

#define PRECISION_FLOAT			1
#define PRECISION_DOUBLE		2
#define PRECISION_LDOUBLE		3
#define PRECISION_LDOUBLE_JULIA	4

#define MAX_PRECISION_SIZE	(sizeof (long double))

#define MAX_SMOOTHLEVEL		10
#define DEFAULT_SMOOTHLEVEL	2

#define MIN_STEP_SMOOTH_SCROLL	30

typedef unsigned short ITER;
typedef long double FLT;

class calculation;
class FractPrefs;


enum FractType
{
	Fract_Mandel=0,
	Fract_Julia
};


class JuliaPreview
{
	public:
		JuliaPreview (QWidget *w);
		void plot();
		void setJuliaConst (long double r, long double i);
		~JuliaPreview();
	private:
		int wi,he;
		QWidget *widget;
		QPainter *painter;
		QPixmap *backpix;
		calculation *juliacalc;
		long double real_const,imag_const;
		long double *cr_buffer;
		long double *ci_buffer;
};



class fractal : public QWidget
{
	Q_OBJECT
	
	friend class FractPrefs;
	friend class JuliaPreview;
	
	public:
	
		fractal(int width, int height);
		~fractal();
		
		QPainter *getPainter () {return painter;}
		
		void createBackPixmap();
		QPixmap *getBackPixmap(){return backpix;}
		
		void resetSize (int width, int height, bool resizeWin=false);
		
		FractType getFractalType() {return fractalType; }
		int getWidth() { return fwidth; }
		int getHeight() { return fheight; }
		ITER getMaxIter()	{	return maxiter;	}
		ITER validIterations (ITER);
		ITER *getData()	{	return data; }
		
		ITER getData (int x, int y) { return data[y*fwidth+x]; }
		ITER getIsoData (int x, int y) { return isodata[y*fwidth+x]; }
		
		ITER getDataSave (int x, int y)
		{
			if (x>=0 && y>=0 && x<=fwidth && y<=fheight)
				return data[y*fwidth+x];
			else
			{
				puts ("fractal::getData out of range!");
				return 0;
			}
		}
		
		ITER getIsoDataSave (int x, int y)
		{
			if (x>=0 && y>=0 && x<=fwidth && y<=fheight)
				return isodata[y*fwidth+x];
			else
			{
				puts ("fractal::getIsoData out of range!");
				return 0;
			}
		}
		
		void setData (int x, int y, ITER d)	{ data[y*fwidth+x]=d; }
		void setIsoData (int x, int y, ITER d)	{ isodata[y*fwidth+x]=d; }

		void setFractalType (FractType f, bool plot);		
		void setPrecision (short p, bool plotmandel=false);
		void setJulia();
		void plotMandel (bool calcit=true);
		void plotMandel (int x1, int y1, int x2, int y2, bool calcit=true);
		void setCoords (FLT r_min, FLT r_max, FLT i_min, FLT i_max);
		void setDefaultCoords();
		void adjustReal();
		void adjustImag();
		void setZoomInOutFactor (short z);
		void setZoomInOutIterChange (short i);
		void zoom (int x, int y, FLT fact, ITER newiter);
		void zoomRange (short rangeX1, short rangeY1, short rangeX2, short rangeY2);
		void changeIterations (ITER newiter);
		void scrollxy (int stepx, int stepy);
		short getSmoothLevel () { return smoothLevel; }
		void setSmoothLevel (short level);
		void smoothData();
		void setFractalTitle ();
		void blitRectangle (short x1, short y1, short x2, short y2, bool drawrect=false);
		bool blitToWinEnabled() { return blitToWin; }

		void openPrefsWindow();
		void closePrefsWindow();
		void updatePrefsWindow();
		bool saveParameters (const char *filename);
		bool loadParameters (const char *filename);
		bool loadPalette (const char *filename);

			
	private:
  	
	  	QPixmap *backpix,*tmp_pix;
  		QPainter *painter;
  		QString prefsname;

  		calculation *calc;
  		FractPrefs *prefsWin;
  		short prefsPosX;
  		short prefsPosY;
  		QSize prefsSize;
  		  		    	
    	FractType fractalType;
    	int fwidth,fheight;
    	int old_fwidth,old_fheight;
    	FLT rmin,imin,rmax,imax;
    	FLT dx,dy;
    	long double julia_rconst;
    	long double julia_iconst;
    	short precision;
    	ITER maxiter;
    	short zoomInOutFactor;
    	short zoomInOutIterChange;
    	void *cr_buffer,*ci_buffer;
    	short maxWidth,maxHeight;
    	short dispWidth,dispHeight;
    	short oldDispWidth,oldDispHeight;
    	short oldDragX,oldDragY;
    	short rangeX1,rangeY1;
    	short rangeX2,rangeY2;
    	short oldRangeX1,oldRangeY1;
    	short oldRangeX2,oldRangeY2;
    	short smoothLevel;
    	ITER *xbuffer;		// buffer for one line (calcPoint)
    	ITER *data;			// pointer to fractal data
    	ITER *isodata;		// fractal data after smoothing
    	long data_size;	// size for malloc
    	
    	bool blitToWin;
    	bool dragMode;
    	bool rangeSelectMode;
    	bool showWindow;
    	bool showCalcStatus;
    	bool paletteLoaded;
    	bool ResizeFlag;
    	bool juliaConstInteractiveMode;
		
	protected:
		void closeEvent (QCloseEvent *);
		void resizeEvent (QResizeEvent *);
		void keyPressEvent (QKeyEvent *);
		void mousePressEvent (QMouseEvent *);
		void mouseReleaseEvent (QMouseEvent *);
		void mouseDoubleClickEvent (QMouseEvent *);
		void mouseMoveEvent (QMouseEvent *);
		void calcCrCiBuffer(int x1, int y1, int x2, int y2);
		void plot (int x1, int y1, int x2, int y2, bool calcit);
		void calcMandelRect (int x1, int y1, int x2, int y2);
		void drawRangeRect();
		void finishRangeMode();
		void scrollWin (int stepx, int stepy);
};

#endif
