/***************************************************************************
                          isowin.h  -  description
                             -------------------
    begin                : Thu Jun 22 2000
    copyright            : (C) 2000 by Helmut Steger
    email                : hel.steger@rolmail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ISOWIN_H
#define ISOWIN_H

#include <qwidget.h>
#include "kisomandel.h"
#include "fractal.h"
#include "settings.h"


#define MIN_ISORES			16
#define MAX_ISORES			200
#define MIN_ISOZOOM			0.1
#define MAX_ISOZOOM			10.0
#define RANGE_ISOZOOM		(MAX_ISOZOOM-MIN_ISOZOOM)
#define ISOMOVE_STEP		4

#define ISOMODE_LINES			1
#define ISOMODE_COLORLINES		2
#define ISOMODE_AREAS			3
#define ISOMODE_BARS			4

#define PI		3.14159265
#define PI2		(PI+PI)




/**
  *@author Helmut Steger
  */

struct BarDrawInfo
{
	short stepy,stepx;
	short barx1,bary1;
	short barx2,bary2;
	short barx3,bary3;
	short barx4,bary4;
};



class fractal;
class IsoPrefs;
class GeneralPrefs;

class isowin : public QWidget
 {
	Q_OBJECT
	
	friend class IsoPrefs;
	friend class GeneralPrefs;

	public:
		isowin (QWidget * parent, const struct GlobalPrefs &gp);
		~isowin();
		
		void resetSize (int width, int height, bool resizeWin=false);
		void createBackPixmap();
		void changeIsoRes (int xres, int yres, bool center=false);
		void changeZoom (float z);
		void setLineWidth (short w);
		void setLineColor (QColor *col);
		void setOutlineColor (QColor *col);
		void setMaxiterColor (QColor *col);
		void setHeightFactor (float f);
		void setAutoHeight (bool f);
		void setRotate (int grad, bool relative=false);
		void setVertRotate (int grad, bool relative=false);
		void setIsoOffset (bool center=false);
		void setIsoOffset (short x, short y, bool center=false);
		void showIso();
		void switchFullScreen();
		void showIsoRange (bool checkhide=true);
   		void hideIsoRange();
		void handleKeyCommand (int key, int state);
	    void updateButtons();
	    void updateMenus();
	    void updatePrefsWin();
	    void setItemCheck (int id, bool flag);
	    void updateMenusAndButtons();
	    void printIso();
	    bool savePicture (const QString filename, const QString fmt);
	    void openPrefsWindow();
		void closePrefsWindow();
		void openGeneralSettingsWindow();
		void closeGeneralSettingsWindow();
	    	
		QColor *getMaxiterColor();
		short getDispMode() {return dispMode;}
	  	int validRes (int res);
		int getRes() { return resX;}
	
	private:
		QPixmap *backpix;
		QPainter *painter;
		QColor linecolor;
		QColor outlinecolor;
		QPen outlinepen;
		
		IsoPrefs *prefsWin;
		short prefsPosX;
		short prefsPosY;
		QSize prefsSize;
		
		GeneralPrefs *generalPrefsWin;
		short generalPrefsPosX;
		short generalPrefsPosY;
		QSize generalPrefsSize;
		
		unsigned short maxiter;
		int isowidth,isoheight;
		int old_isowidth,old_isoheight;
		int centerX,centerY;
		double centerRelX,centerRelY;
		int sizeX,sizeY;
		int resX,resY;
		int startX,startY;
		int drawYStart;
		int isomin,isomax;
		
		int oldVertRotatePos;
		int oldZoomPos;
		int firstDragAngle,oldDragAngle;
		int centerFirstX,centerFirstY;
		
		short blitMinX,blitMinY;
		short blitMaxX,blitMaxY;
		short oldBlitMinX,oldBlitMinY;
		short oldBlitMaxX,oldBlitMaxY;
    	
    	short isoRangeX,isoRangeY;
    	short isoRangeWidth,isoRangeHeight;
    	bool isoRangeDrawn;
		
		short dispMode;
		short lineWidth;
		bool showHorLines;
		bool showVerLines;
		bool areaOutline;
		bool autoHeight;
		bool fullScreen;
		bool printMode;

 		float drawHeight;
 		float heightFactor;
		float zoom;
	    float rotate;
    	float vert_rotate;

        short drawX[MAX_ISORES][MAX_ISORES];
        short drawY[MAX_ISORES][MAX_ISORES];
		
	protected:
		void mousePressEvent (QMouseEvent *);
		void mouseMoveEvent (QMouseEvent *);
		void resizeEvent (QResizeEvent *);
		void keyPressEvent (QKeyEvent *);
		
		void init();
	  	void calcDrawXY();
  		void calcIsoSize();
	  	void setZoom (float z);
		void clearIso();
		void blitIso();
		short inline getFractDat (short x, short y);
		short inline getIsoDat (short x, short y);
		void getIsoMinMax();
		float calcDrawHeight();
		short inline calcCoord (QPointArray &p, short i, short x, short y, short ax, short ay);
		void inline calcBarCoord (QPointArray &p, short i, short x, short y, short ax, short ay, short barY);
		short getAreaColor (short isodat);
		void inline fillBar (QPointArray &p, QColor * col);
		short calcQuadrant();
	    void showIsoLines(bool colormode=false);
	    void showIsoAreas();
	    void showIsoBars();
	    void initBlitRange();
	    void adjustBlitRange (short x, short y);
	    void drawIsoRangeRect();
		void activateButton (short id, bool activate, bool enable=true);
};


#endif
