/***************************************************************************
                          kisomandel.cpp  -  description
                             -------------------
    begin                : Don Jun 22 21:00:19 CEST 2000
    copyright            : (C) 2000 by Helmut Steger
    email                : hel.steger@rolmail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kisomandel.h"
#include "filesave.xpm"
#include "fileopen.xpm"
#include "linien.xpm"
#include "linien_farbe.xpm"
#include "flaechen.xpm"
#include "balken.xpm"
#include "outline.xpm"
#include "smoothing_more.xpm"
#include "smoothing_less.xpm"
#include "paletteopen.xpm"
#include "fullscreen.xpm"
#include "kisomandel-logo.xpm"



AboutKisomandel::AboutKisomandel (const QPixmap &logo)
{
  	PixmapLabel_Logo->setBackgroundPixmap (logo);
  	TextLabel_Version->setText ("Version " VERSION " (" VERSION_DATE ")" );
  	PushButton_Close->setDefault (true);
}


void AboutKisomandel::closeEvent (QCloseEvent *e)
{
	kisomandel->closeAboutDialog();
	e->accept();
}


void AboutKisomandel::accept ()
{
	kisomandel->closeAboutDialog();
}
	



Kisomandel::Kisomandel (int w, int h)
{
	toolBar=NULL;		// avoids crash on KDE 2
    about_dialog=NULL;
    about_pixmap=NULL;
	
	setCaption("Kisomandel " VERSION);
	setGeometry (0,0,w,h);
	createIconPixmaps();
	initGlobalPrefs();
	initMenuBar();
	initToolBar();
	initStatusBar();
	setupMainWindow();
}


Kisomandel::~Kisomandel()
{
	closeAboutDialog();
	if (about_pixmap) delete about_pixmap;
}


void Kisomandel::closeAboutDialog()
{
	if (about_dialog) delete about_dialog;
	about_dialog=NULL;
}


void Kisomandel::initGlobalPrefs()
{
	QDir homepath = QDir::homeDirPath();

	globalPrefs.isoResolution=24;
	globalPrefs.isoHeight=100;	// 100%
	globalPrefs.autoHeight=true;
	globalPrefs.isoZoom=100;	// 100%
	globalPrefs.isoSmoothing=2;
	globalPrefs.areaOutline=false;
	globalPrefs.lineColor=QColor (100,100,250);
	globalPrefs.outlineColor=black;
	globalPrefs.maxiterColor=QColor (40,40,40);
	
	globalPrefs.paletteDir=homepath;
	globalPrefs.fractPrefsDir=homepath;
	
	globalPrefs.fractalType=Fract_Mandel;
	globalPrefs.paletteFileAtStart="";
	globalPrefs.loadPaletteAtStart=false;
	globalPrefs.showStatusBar=true;
	globalPrefs.showToolBar=true;
	
	loadGlobalPrefs();	// try to load settings from file .kisomandelrc in the user's home directory

	prefsFileName=globalPrefs.fractPrefsDir.path();
	paletteFileName=globalPrefs.paletteDir.path();
	pictureFileName=homepath.path();
}	


void Kisomandel::setItemCheck (int id, bool flag)
{
	menuBar()->setItemChecked (id,flag);
}


void Kisomandel::initMenuBar()
{
  QImageIO imgIO;
  QString tmp;
  int i;

  imageFormats=imgIO.outputFormats();	// picture formats for save (PNG, BMP, JPEG, ...)

  fileMenu=new QPopupMenu();
  fileMenu->insertItem(icons[ID_BUTTON_FILEOPEN],"&Open...",		this, SLOT(slotFileOpen()),		CTRL+Key_O, ID_FILE_OPEN);
  fileMenu->insertItem("&Save...",			this, SLOT(slotFileSave()),		CTRL+Key_S, ID_FILE_SAVE);
  fileMenu->insertSeparator();
  fileMenu->insertItem(icons[ID_BUTTON_PALETTE_OPEN],"Load palette...",this,SLOT(slotLoadPalette()),0,ID_FILE_LOAD_PALETTE);
  fileMenu->insertSeparator();
  fileMenu->insertItem("&Print Iso...",		this, SLOT(slotFilePrint()),	CTRL+Key_P, ID_FILE_PRINT);

  fileMenuSaveFormats=new QPopupMenu();
  tmp=imageFormats.first();
  for (i=0; !tmp.isEmpty() && i<50;i++)
  {
	  fileMenuSaveFormats->insertItem(tmp,this, SLOT(slotSavePictureFormat(int)),0, ID_FILE_SAVEPIC_FORMAT+i);
	  tmp=imageFormats.next();
  }
  	
  fileMenu->insertItem ("Save Iso picture",fileMenuSaveFormats);

  fileMenu->insertSeparator();
  fileMenu->insertItem("General settings...",this,SLOT(slotGeneralSettings()),0,ID_FILE_GENERAL_SETTINGS);
  fileMenu->insertSeparator();
  fileMenu->insertItem("E&xit",			this, SLOT(slotFileQuit()),		CTRL+Key_Q, ID_FILE_QUIT);

  isoMenu=new QPopupMenu();
	  isoMenuDisplayMode=new QPopupMenu();
	  isoMenuDisplayMode->insertItem(icons[ID_BUTTON_LINES],		"Lines (single color)",	this, SLOT(slotLineMode()),			Key_F1, ID_ISO_DISPLAY_LINES);
	  isoMenuDisplayMode->insertItem(icons[ID_BUTTON_COLORLINES],	"Lines (multi color)",	this, SLOT(slotColorLineMode()),	Key_F2, ID_ISO_DISPLAY_COLORLINES);
	  isoMenuDisplayMode->insertItem(icons[ID_BUTTON_AREAS],		"Areas",				this, SLOT(slotAreaMode()),			Key_F3, ID_ISO_DISPLAY_AREAS);
	  isoMenuDisplayMode->insertItem(icons[ID_BUTTON_BARS],			"3D Bars",				this, SLOT(slotBarMode()),			Key_F4, ID_ISO_DISPLAY_BARS);
  isoMenu->insertItem ("Display mode",isoMenuDisplayMode);
	  isoMenuSmoothing=new QPopupMenu();
	  isoMenuSmoothing->insertItem("None",	this, SLOT(slotIsoSmoothing_None()),'0', ID_ISO_SMOOTHING_NONE);
	  isoMenuSmoothing->insertSeparator();
	
	  for (i=0;i<10;i++)	// Iso smoothing 1 to 10
	  {
	  	  tmp.sprintf ("%d",i+1);
		  isoMenuSmoothing->insertItem(tmp,this,SLOT(slotIsoSmoothing(int)),0, ID_ISO_SMOOTHING_1+i);
	  }
	
	  isoMenuSmoothing->insertSeparator();
	  isoMenuSmoothing->insertItem("More",	this, SLOT(slotIsoSmoothingMore()),	'>',ID_ISO_SMOOTHING_MORE);
	  isoMenuSmoothing->insertItem("Less",	this, SLOT(slotIsoSmoothingLess()),	'<',ID_ISO_SMOOTHING_LESS);
  isoMenu->insertItem ("Smoothing",isoMenuSmoothing);	

  isoMenu->insertSeparator();
  isoMenu->insertItem("Area Outline",		this, SLOT(slotAreaOutline()),		'O',		ID_ISO_AREAOUTLINE);
  isoMenu->insertItem("Auto Height",		this, SLOT(slotAutoHeight()),		Key_F5,		ID_ISO_AUTOHEIGHT);
  isoMenu->insertItem("Horizontal Lines",	this, SLOT(slotHorizontalLines()),	Key_F6,		ID_ISO_HORLINES);
  isoMenu->insertItem("Vertical Lines",		this, SLOT(slotVerticalLines()),	Key_F7,		ID_ISO_VERLINES);
  isoMenu->insertSeparator();
  isoMenu->insertItem(icons[ID_BUTTON_FULLSCREEN],"Full Screen",	this, SLOT(slotIsoFullScreen()),Key_F11,ID_ISO_FULLSCREEN);
  isoMenu->insertSeparator();
  isoMenu->insertItem("Settings ...",this,SLOT(slotIsoSettings()),0,ID_ISO_SETTINGS);


  fractMenu=new QPopupMenu();
  	fractTypeMenu=new QPopupMenu();
  	fractTypeMenu->insertItem("Mandelbrot",			this,SLOT(slotFractTypeMandel()),		'M',	ID_FRACT_FRACTTYPE_MANDEL);
  	fractTypeMenu->insertItem("Julia",				this,SLOT(slotFractTypeJulia()),		'J',	ID_FRACT_FRACTTYPE_JULIA);
  fractMenu->insertItem ("Fractal type",fractTypeMenu);
  fractMenu->insertItem ("Reset to default coords",	this,SLOT(slotFractDefaultCoords()),	0,		ID_FRACT_DEFAULT_COORDS);
  fractMenu->insertSeparator();
  fractMenu->insertItem ("Adjust window size",		this,SLOT(slotFractAdjustWinSize()),	0,		ID_FRACT_ADJUST_WINSIZE);
  fractMenu->insertItem ("Adjust real (width)",		this,SLOT(slotFractAdjustReal()),		0,		ID_FRACT_ADJUST_REAL);
  fractMenu->insertItem ("Adjust imag. (height)",	this,SLOT(slotFractAdjustImag()),		0,		ID_FRACT_ADJUST_IMAG);
  fractMenu->insertSeparator();
  fractMenu->insertItem ("Settings ...",			this,SLOT(slotFractSettings()),			Key_F12,ID_FRACT_SETTINGS);



  ///////////////////////////////////////////////////////////////////
  // menuBar entry viewMenu
  viewMenu=new QPopupMenu();
  viewMenu->setCheckable(true);
  viewMenu->insertItem("Tool&bar",		this, SLOT(slotViewToolBar()),	0, ID_VIEW_TOOLBAR);
  viewMenu->insertItem("&Statusbar",	this, SLOT(slotViewStatusBar()),0, ID_VIEW_STATUSBAR);

  viewMenu->setItemChecked(ID_VIEW_TOOLBAR, globalPrefs.showToolBar);
  viewMenu->setItemChecked(ID_VIEW_STATUSBAR, globalPrefs.showStatusBar);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry helpMenu
  helpMenu=new QPopupMenu();
  helpMenu->insertItem("About...",		this, SLOT(slotHelpAbout()),	0, ID_HELP_ABOUT);
  helpMenu->insertItem("About Qt...",	this, SLOT(slotHelpAboutQt()),	0, ID_HELP_ABOUT_QT);


  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // set menuBar() the current menuBar 

  menuBar()->insertItem ("&File", fileMenu);
  menuBar()->insertItem ("Iso",isoMenu);
  menuBar()->insertItem ("Fractal",fractMenu);
  menuBar()->insertItem ("&View", viewMenu);
  menuBar()->insertSeparator();
  menuBar()->insertItem ("&Help", helpMenu);
  
  ///////////////////////////////////////////////////////////////////
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS

  connect(fileMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  connect(viewMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  connect(helpMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  
}


void Kisomandel::createIconPixmaps()
{
  icons[ID_BUTTON_FILEOPEN] 		= QPixmap (fileopen);
  icons[ID_BUTTON_FILESAVE] 		= QPixmap (filesave);
  icons[ID_BUTTON_LINES]			= QPixmap (linien);
  icons[ID_BUTTON_COLORLINES]		= QPixmap (linien_farbe);
  icons[ID_BUTTON_AREAS]			= QPixmap (flaechen);
  icons[ID_BUTTON_BARS]				= QPixmap (balken);
  icons[ID_BUTTON_OUTLINE]			= QPixmap (outline);
  icons[ID_BUTTON_SMOOTHING_MORE]	= QPixmap (smoothing_more);
  icons[ID_BUTTON_SMOOTHING_LESS]	= QPixmap (smoothing_less);
  icons[ID_BUTTON_PALETTE_OPEN]		= QPixmap (paletteopen);
  icons[ID_BUTTON_FULLSCREEN]		= QPixmap (fullscreen);
}	


QToolButton * Kisomandel::getButton (short id)
{
	if (id>=0 && id<NUM_BUTTONS)
		return buttons[id];
	else
		return NULL;
}


void Kisomandel::addToolButton (short id, const char *infotext, const char *slot, const char *whatsthis)
{
	if (id < 0 || id >= NUM_BUTTONS) return;
	if (toolBar == NULL)
	{
		toolBar = new QToolBar(this);
		// toolBar->setHorizontalStretchable (false);
	}
	buttons[id] = new QToolButton (icons[id],infotext,0,this,slot,toolBar);
	if (whatsthis)
	{
		QWhatsThis::add (buttons[id],whatsthis);
	}
}


void Kisomandel::initToolBar()
{
  addToolButton (ID_BUTTON_FILEOPEN,		"Open fractal parameters",	SLOT(slotFileOpen())										);
  addToolButton (ID_BUTTON_FILESAVE,		"Save fractal parameters",	SLOT(slotFileSave())										);
  addToolButton (ID_BUTTON_LINES,			"Line Mode",				SLOT(slotLineMode()),			IDS_WHATSTHIS_LINEMODE		);
  addToolButton (ID_BUTTON_COLORLINES,		"Line Color Mode",			SLOT(slotColorLineMode()),		IDS_WHATSTHIS_LINECOLORMODE	);
  addToolButton (ID_BUTTON_AREAS,			"Area Mode",				SLOT(slotAreaMode()),			IDS_WHATSTHIS_AREAMODE		);
  addToolButton (ID_BUTTON_BARS,			"Bar Mode",					SLOT(slotBarMode()),			IDS_WHATSTHIS_BARMODE		);
  addToolButton (ID_BUTTON_OUTLINE,			"Area Outline",				SLOT(slotAreaOutline()),		IDS_WHATSTHIS_OUTLINE		);
  addToolButton (ID_BUTTON_SMOOTHING_MORE,	"More smoothing",			SLOT(slotIsoSmoothingMore()),	IDS_WHATSTHIS_SMOOTHING_MORE);
  addToolButton (ID_BUTTON_SMOOTHING_LESS,	"Less smoothing",			SLOT(slotIsoSmoothingLess()),	IDS_WHATSTHIS_SMOOTHING_LESS);
  addToolButton (ID_BUTTON_PALETTE_OPEN,	"Open palette",				SLOT(slotLoadPalette()),		IDS_WHATSTHIS_OPEN_PALETTE);
  addToolButton (ID_BUTTON_FULLSCREEN,		"Full screen on/off",		SLOT(slotIsoFullScreen()),		IDS_WHATSTHIS_FULLSCREEN);

  //toolBar->addSeparator();
  //QWhatsThis::whatsThisButton(toolBar);

  if (globalPrefs.showToolBar) toolBar->show(); else toolBar->hide();

}


void Kisomandel::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->message(IDS_STATUS_DEFAULT, 2000);
  if (globalPrefs.showStatusBar) statusBar()->show(); else statusBar()->hide();
}


void Kisomandel::notyet()
{
	QMessageBox::information (this,"Info","Not yet implemented ;-(",QMessageBox::Ok);
}


bool Kisomandel::queryExit()
{
  int exit=QMessageBox::information(
  	this,
  	"Kisomandel",
    "Do you really want to quit?",
    QMessageBox::Ok, QMessageBox::Cancel);

 return (exit==1);
}


void Kisomandel::closeEvent (QCloseEvent *e)
{
	slotFileQuit();
}


void Kisomandel::handleCommand (int key, int state)
{
	mainwin->handleKeyCommand (key,state);
}


void Kisomandel::keyPressEvent (QKeyEvent *e)
{
	handleCommand ( e->key(),e->state() );
}


void Kisomandel::loadGlobalPrefs()
{
	FILE *f;
	char PaletteDir[300];
	char PaletteAtStart[300];
	char FractPrefsDir[300];
	char FractType[50];
	char LineColor[10];
	char OutlineColor[10];
	char MaxiterColor[10];
	
    struct Prefs gp[]=
    {
    	{"PaletteDir",			0,PaletteDir,sizeof(PaletteDir)-1,false},
    	{"PaletteAtStart",		0,PaletteAtStart,sizeof(PaletteAtStart)-1,false},
    	{"LoadPaletteAtStart",	0,NULL,0,false},
    	{"FractPrefsDir",		0,FractPrefsDir,sizeof(FractPrefsDir)-1,false},
    	{"IsoResolution",		0,NULL,0,false},
    	{"IsoHeight",			0,NULL,0,false},
    	{"IsoAutoHeight",		0,NULL,0,false},
    	{"IsoZoom",				0,NULL,0,false},
    	{"IsoSmoothing",		0,NULL,0,false},
    	{"AreaOutline",			0,NULL,0,false},
    	{"LineColor",			0,LineColor,sizeof(LineColor)-1,false},
    	{"OutlineColor",		0,OutlineColor,sizeof(OutlineColor)-1,false},
    	{"MaxiterColor",		0,MaxiterColor,sizeof(MaxiterColor)-1,false},
    	{"FractalType",			0,FractType,sizeof(FractType)-1,false},
    	{"ShowStatusBar",		0,NULL,0,false},
    	{"ShowToolBar",			0,NULL,0,false},
    	{NULL,0,NULL,0,false}	// end prefs
    };

	QString cur_path=QDir::currentDirPath();
	QDir d = QDir::home();
	QDir::setCurrent (d.path());	// search settings file in user's home directory
	f=fopen (".kisomandelrc","r");
	if (f)	// file found
	{
		char s[500];
		char token[50];
		char str_val[300];
		PREFVAL num_val;
		
        while ( ! feof(f) )
        {
        	int len;
        	fgets (s,sizeof(s)-1,f);	// read one line
        	len=strlen(s);
        	if (len>0) if (s[len-1]=='\n') s[len-1]=0;
      			
      		// try to get token with numeric value
      		if (sscanf (s,"%40s " PREFVAL_FMT ,&token,&num_val) == 2)	// token and value scanned
      		{
      		 	prefsSetTokenValue (gp,token,num_val);
      		}
      		
      		// try to get token with string value
      		if (sscanf (s,"%40s ",&token) == 1)
      		{
      			QString tmp = s;
      			QString tmp2 = tmp.right(tmp.length() - strlen(token));
      			tmp = tmp2.stripWhiteSpace();
      			if (tmp.left(1) == "\"") tmp.remove (0,1);	// remove first char (")
      			if (tmp.right(1) == "\"") tmp.truncate (tmp.length()-1); // remove last char (")
      			if (tmp.length() > 0)
      			{
      				strncpy (str_val,(const char *)tmp,sizeof(str_val));
	      		 	prefsSetTokenValue (gp,token,str_val);
	    		}
      		}
      	
      	} // while

		fclose (f);
		
		if (prefsGetTokenValue (gp,"PaletteDir",s))			globalPrefs.paletteDir=s;
		if (prefsGetTokenValue (gp,"PaletteAtStart",s))		globalPrefs.paletteFileAtStart=s;
		if (prefsGetTokenValue (gp,"FractPrefsDir",s))		globalPrefs.fractPrefsDir=s;
		
		if (prefsGetTokenValue (gp,"LoadPaletteAtStart",num_val))
		{
			short i=(short)num_val;
			globalPrefs.loadPaletteAtStart = (i != 0);
		}
		
		if (prefsGetTokenValue (gp,"IsoResolution",num_val))
		{
			int i=(int)num_val;
			globalPrefs.isoResolution=mainwin->validRes(i);
		}
		
		if (prefsGetTokenValue (gp,"IsoHeight",num_val))
		{
			int i=(int)num_val;
			if (i<10) i=10;
			if (i>200) i=200;
			globalPrefs.isoHeight=i;
		}
		
		if (prefsGetTokenValue (gp,"IsoAutoHeight",num_val))
		{
			short i=(short)num_val;
			globalPrefs.autoHeight = (i != 0);
		}
		
		if (prefsGetTokenValue (gp,"IsoZoom",num_val))
		{
			int i=(int)num_val;
			if (i<10) i=10;
			if (i>1000) i=1000;
			globalPrefs.isoZoom=i;
		}
		
		if (prefsGetTokenValue (gp,"IsoSmoothing",num_val))
		{
			int i=(int)num_val;
			if (i<0) i=0;
			if (i>10) i=10;
			globalPrefs.isoSmoothing=i;
		}
		
		if (prefsGetTokenValue (gp,"AreaOutline",num_val))
		{
			short i=(short)num_val;
			globalPrefs.areaOutline = (i != 0);
		}
		
		if (prefsGetTokenValue (gp,"LineColor",str_val))
    	{
    		setColorFromString (globalPrefs.lineColor,str_val);
    	}
		
		if (prefsGetTokenValue (gp,"OutlineColor",str_val))
    	{
    		setColorFromString (globalPrefs.outlineColor,str_val);
    	}
		
		if (prefsGetTokenValue (gp,"MaxiterColor",str_val))
    	{
    		setColorFromString (globalPrefs.maxiterColor,str_val);
    	}
		
		if (prefsGetTokenValue (gp,"FractalType",str_val))
    	{
    		QString s = str_val;
    		if (s.lower() == "mandelbrot" || s.lower() == "mandel") globalPrefs.fractalType=Fract_Mandel;
    		if (s.lower() == "julia") globalPrefs.fractalType=Fract_Julia;
    	}
		
		if (prefsGetTokenValue (gp,"ShowStatusBar",num_val))
		{
			short i=(short)num_val;
			globalPrefs.showStatusBar = (i != 0);
		}
		
		if (prefsGetTokenValue (gp,"ShowToolBar",num_val))
		{
			short i=(short)num_val;
			globalPrefs.showToolBar = (i != 0);
		}

	}	// if (f)
	
	QDir::setCurrent (cur_path);
}



/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////



void Kisomandel::slotFileOpen()
{
  statusBar()->message("Loading fractal parameters...");

  QString s=prefsFileName;
  QFileInfo fi (s);
  if (! fi.isDir()) s=fi.dirPath();

  QString fileName = QFileDialog::getOpenFileName(s,0,this,0,"Open fractal parameters");

  if (!fileName.isEmpty())
  {
	if ( fract->loadParameters ((const char *)fileName) )
	{
		mainwin->updateMenusAndButtons();
		prefsFileName=fileName;		// remember preferences filename
	    QString message="Loaded fractal parameters: "+fileName;
	    statusBar()->message(message, 2000);
	}
  }
  else
  {
    statusBar()->message("Loading fractal parameters aborted", 2000);
  }
}


void Kisomandel::slotFileSave()
{
  statusBar()->message("Saving fractal parameters...");

  QString s=prefsFileName;
  QFileInfo fi (s);
  if (!fi.isDir()) s=fi.dirPath();

  QString fileName = QFileDialog::getSaveFileName(s,0,this,0,"Save fractal parameters");
  if (!fileName.isEmpty())
  {
	if (fract->saveParameters ((const char *)fileName))
	{
		prefsFileName=fileName;
	}
  }
  else
  {
    statusBar()->message("Saving aborted", 2000);
  }
  statusBar()->message(IDS_STATUS_DEFAULT);
}


void Kisomandel::slotLoadPalette()
{
  statusBar()->message("Loading palette...");

  QString s=paletteFileName;
  QFileInfo fi (s);
  if (! fi.isDir()) s=fi.dirPath();

  QString fileName = QFileDialog::getOpenFileName(s,0,this,0,"Select palette file");
  	
  if (!fileName.isEmpty())
  {
    	if ( fract->loadPalette ((const char *)fileName) )
    	{
    		paletteFileName=fileName;		// remember palette filename
    	    QString message="Palette loaded: "+fileName;
    	    statusBar()->message(message, 2000);
    	}
   }
   else
   {
    	statusBar()->message("Loading palette aborted", 2000);
   }
}	


void Kisomandel::slotFilePrint()
{
  statusBar()->message("Printing...");
  mainwin->printIso();
  statusBar()->message(IDS_STATUS_DEFAULT);
}


void Kisomandel::slotGeneralSettings()
{
	mainwin->openGeneralSettingsWindow();
}


void Kisomandel::slotFileQuit()
{ 
  statusBar()->message("Exiting application...");
  if(queryExit())
  {
    qApp->quit();
  }

  statusBar()->message(IDS_STATUS_DEFAULT);
}


void Kisomandel::slotViewToolBar()
{
  statusBar()->message("Toggle toolbar...");

  if (toolBar->isVisible())
  {
    toolBar->hide();
    viewMenu->setItemChecked(ID_VIEW_TOOLBAR, false);
  } 
  else
  {
    toolBar->show();
    viewMenu->setItemChecked(ID_VIEW_TOOLBAR, true);
  };

  statusBar()->message(IDS_STATUS_DEFAULT);
}


void Kisomandel::slotViewStatusBar()
{
  statusBar()->message("Toggle statusbar...");

  if (statusBar()->isVisible())
  {
    statusBar()->hide();
    viewMenu->setItemChecked(ID_VIEW_STATUSBAR, false);
  }
  else
  {
    statusBar()->show();
    viewMenu->setItemChecked(ID_VIEW_STATUSBAR, true);
  }
  
  statusBar()->message(IDS_STATUS_DEFAULT);
}


void Kisomandel::slotHelpAbout()
{
  if (!about_pixmap) about_pixmap = new QPixmap (kisomandel_logo_xpm);	// create logo-pixmap only once
  if (!about_dialog) about_dialog = new AboutKisomandel (*about_pixmap);
  about_dialog->show();
  about_dialog->raise();
}


void Kisomandel::slotHelpAboutQt()
{
  QMessageBox::aboutQt(this,"Kisomandel");
}


void Kisomandel::slotStatusHelpMsg (const QString &text)
{
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}


void Kisomandel::slotSavePictureFormat (int id_)
{
  QString save_fmt,tmp;
  save_fmt=imageFormats.at (id_ - ID_FILE_SAVEPIC_FORMAT);	// JPG, BMP, PNG, ...
  statusBar()->message("Save as picture...");

  QString s = pictureFileName;
  QFileInfo fi (s);
  if (!fi.isDir()) s=fi.dirPath();

  QString fileName = QFileDialog::getSaveFileName(s,0,this,0,"Save Iso picture (" + save_fmt + ")");
  if (!fileName.isEmpty())
  {
	if ( mainwin->savePicture (fileName, save_fmt) )
	{
		pictureFileName=fileName;		// remember picture filename
	    QString message="Saved " + save_fmt + " picture: " + fileName;
	    statusBar()->message(message, 2000);
	}
	else
	{
		tmp = "Could not save picture!\nFormat: " + save_fmt + "\nFilename: " + fileName;
   		QMessageBox::critical (
	   		this,
   			"Error",
   			tmp);
	}
  }
  else
  {
    statusBar()->message("Save picture aborted.", 2000);
  }
}


void Kisomandel::statusCallback (int id_)
{
  QString s;

  switch (id_)
  {
    case ID_FILE_OPEN:
    	s="Open fractal parameters";
    	break;
    case ID_FILE_SAVE:
    	s="Save fractal parameters";
    	break;
    case ID_FILE_LOAD_PALETTE:
    	s="Load palette from file";
    	break;
    case ID_FILE_PRINT:
    	s="Print iso window";
    	break;
    case ID_FILE_GENERAL_SETTINGS:
    	s="Change general settings";
    	break;
    case ID_FILE_QUIT:
        s="Quit Kisomandel";
        break;

    case ID_VIEW_TOOLBAR:
    	s="Show/hide the toolbar";
        break;
    case ID_VIEW_STATUSBAR:
    	s="Show/hide the statusbar";
        break;
  }
  if (! s.isEmpty() ) slotStatusHelpMsg (s);
}


void Kisomandel::slotLineMode()
{
	handleCommand (Key_F1);
}


void Kisomandel::slotColorLineMode()
{
	handleCommand (Key_F2);
}


void Kisomandel::slotAreaMode()
{
	handleCommand (Key_F3);
}


void Kisomandel::slotBarMode()
{
	handleCommand (Key_F4);
}


void Kisomandel::setIsoSmoothing (int level)
{	
	if (level != fract->getSmoothLevel())
	{
    	fract->setSmoothLevel (level);
    	fract->smoothData();
    	mainwin->showIso();
    	mainwin->updateMenusAndButtons();
    }
}


void Kisomandel::slotIsoSmoothing (int level)
{	
	setIsoSmoothing (level+1-ID_ISO_SMOOTHING_1);
}


void Kisomandel::slotIsoSmoothing_None()
{
	setIsoSmoothing (0);
}


void Kisomandel::slotIsoSmoothingMore()
{
	setIsoSmoothing (fract->getSmoothLevel()+1);
}


void Kisomandel::slotIsoSmoothingLess()
{
	setIsoSmoothing (fract->getSmoothLevel()-1);
}


void Kisomandel::slotAreaOutline()
{
	handleCommand ('O');
}


void Kisomandel::slotAutoHeight()
{
	handleCommand (Key_F5);
}


void Kisomandel::slotHorizontalLines()
{
	handleCommand (Key_F6);
}


void Kisomandel::slotVerticalLines()
{
	handleCommand (Key_F7);
}


void Kisomandel::slotIsoFullScreen()
{
	mainwin->switchFullScreen();
}


void Kisomandel::slotIsoSettings()
{
	mainwin->openPrefsWindow();
}


void Kisomandel::slotFractTypeMandel()
{
	fract->setFractalType (Fract_Mandel,true);
   	mainwin->updateMenusAndButtons();
}


void Kisomandel::slotFractTypeJulia()
{
	fract->setFractalType (Fract_Julia,true);
   	mainwin->updateMenusAndButtons();
}


void Kisomandel::slotFractDefaultCoords()
{
	fract->setDefaultCoords();
    fract->changeIterations (DEFAULT_ITER);
	fract->plotMandel();
	fract->updatePrefsWindow();
}


void Kisomandel::slotFractAdjustWinSize()
{
	int w=fract->getWidth();
	int h=fract->getHeight();
	
	if (w>h)
		fract->resetSize (w,w*384/512,true);
	else
		fract->resetSize (h*512/384,h,true);
}


void Kisomandel::slotFractAdjustReal()
{
	fract->adjustReal();
}


void Kisomandel::slotFractAdjustImag()
{
	fract->adjustImag();
}

	
void Kisomandel::slotFractSettings()
{
	fract->openPrefsWindow();
}


void Kisomandel::setupMainWindow()
{
	mainwin = new isowin (this,globalPrefs);
	setCentralWidget(mainwin);
}


void Kisomandel::loadInitialPalette()
{
	if (globalPrefs.loadPaletteAtStart)
	{
		fract->loadPalette ((const char *)globalPrefs.paletteFileAtStart);
	}
}
	