/***************************************************************************
                          kisomandel.h  -  description
                             -------------------
    begin                : Don Jun 22 21:00:19 CEST 2000
    copyright            : (C) 2000 by Helmut Steger
    email                : hel.steger@rolmail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                    g                                                     *
 ***************************************************************************/

#ifndef KISOMANDEL_H
#define KISOMANDEL_H

// include files for QT
#include <qstring.h>
#include <qstrlist.h>
#include <qpopupmenu.h>
#include <qmainwindow.h>
#include <qaccel.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qtoolbutton.h>
#include <qapp.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qmsgbox.h>
#include <qfiledialog.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <qsize.h>
#include <qcolordialog.h>

// other includes

#include <stdio.h>


// application specific includes
#include "resource.h"
#include "isowin.h"
#include "calc.h"
#include "fractal.h"
#include "misc.h"
#include "aboutdialog_form.h"

class fractal;
class Kisomandel;
class isowin;
class IsoPrefs;

extern fractal *fract;
extern Kisomandel *kisomandel;
extern isowin *mainwin;


#define WIN_MINWIDTH 		320
#define WIN_MINHEIGHT 		200

enum Buttons
{
	ID_BUTTON_FILEOPEN = 0,
	ID_BUTTON_FILESAVE,
	ID_BUTTON_LINES,
	ID_BUTTON_COLORLINES,
	ID_BUTTON_AREAS,
	ID_BUTTON_BARS,
	ID_BUTTON_OUTLINE,
	ID_BUTTON_SMOOTHING_MORE,
	ID_BUTTON_SMOOTHING_LESS,
	ID_BUTTON_PALETTE_OPEN,
	ID_BUTTON_FULLSCREEN,
	NUM_BUTTONS
};


struct GlobalPrefs
{
	QDir paletteDir;
	QDir fractPrefsDir;
	short isoResolution;
	short isoHeight;
	bool autoHeight;
	short isoZoom;
	short isoSmoothing;
	short fractalType;
	bool areaOutline;
	QColor lineColor;
	QColor outlineColor;
	QColor maxiterColor;
	QString paletteFileAtStart;
	bool loadPaletteAtStart;
	bool showStatusBar;
	bool showToolBar;
};
	


class AboutKisomandel : public AboutDialog
{
  Q_OBJECT

  public:
  	AboutKisomandel (const QPixmap &logo);

  public slots:
  	virtual void accept();


  protected:
  	void closeEvent (QCloseEvent *);
};



class Kisomandel : public QMainWindow
{
  Q_OBJECT

  friend class GeneralPrefs;

  public:
    Kisomandel(int w, int h);
    ~Kisomandel();
    void initGlobalPrefs();
    void initMenuBar();
    void initToolBar();
    void initStatusBar();
	void setupMainWindow();
	void loadInitialPalette();
	void closeAboutDialog();

    bool queryExit();
	QToolButton * getButton (short id);
	void setItemCheck (int id, bool flag);
	QPopupMenu *getIsoMenu() { return isoMenu; }
	QPopupMenu *getFractMenu() { return fractMenu; }
	short getStartFractalType() {return globalPrefs.fractalType; }


   public slots:

    void statusCallback(int id_);
    void slotSavePictureFormat(int id_);

    void slotFileOpen();
    void slotFileSave();
    void slotLoadPalette();
    void slotFilePrint();
    void slotGeneralSettings();
    void slotFileQuit();

    void slotViewToolBar();
    void slotViewStatusBar();

    void slotLineMode();
    void slotColorLineMode();
    void slotAreaMode();
    void slotBarMode();
    void slotIsoSmoothing_None();
    void slotIsoSmoothing(int);
    void slotIsoSmoothingMore();
    void slotIsoSmoothingLess();
    void slotAreaOutline();
    void slotAutoHeight();
    void slotHorizontalLines();
    void slotVerticalLines();
    void slotIsoFullScreen();
    void slotIsoSettings();

    void slotFractTypeMandel();
    void slotFractTypeJulia();
    void slotFractDefaultCoords();
    void slotFractAdjustWinSize();
    void slotFractAdjustReal();
	void slotFractAdjustImag();
	void slotFractSettings();

    void notyet();
    void slotHelpAbout();
    void slotHelpAboutQt();
    void slotStatusHelpMsg(const QString &text);

  private:

    QPopupMenu *fileMenu,*fileMenuSaveFormats;
    QPopupMenu *isoMenu,*isoMenuDisplayMode,*isoMenuSmoothing;
    QPopupMenu *fractMenu,*fractTypeMenu;
    QPopupMenu *viewMenu;
    QPopupMenu *helpMenu;

    GlobalPrefs globalPrefs;

    QStrList imageFormats;
    QString prefsFileName;
    QString paletteFileName;
    QString pictureFileName;

    QToolBar *toolBar;
    QPixmap icons[NUM_BUTTONS];
    QToolButton *buttons[NUM_BUTTONS];

    AboutKisomandel *about_dialog;
    QPixmap *about_pixmap;

  protected:
 	 void closeEvent (QCloseEvent *);
	 void keyPressEvent (QKeyEvent *);
	 void loadGlobalPrefs();
	 void createIconPixmaps();
     void addToolButton (short id, const char *infotext, const char *slot, const char *whatsthis=NULL);
	 void handleCommand (int key, int state=0);
	 void setIsoSmoothing (int level);

};

#endif

