/***************************************************************************
                          misc.cpp  -  description
                             -------------------
    begin                : Fri Jun 23 2000
    copyright            : (C) 2000 by Helmut Steger
    email                : hel.steger@rolmail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <math.h>
#include "kisomandel.h"
#include "misc.h"
#include "fractal.h"

QColor *colorpalette[MAX_ITER+2];
QColor *colorpalette_bright[MAX_ITER+2];
QColor *colorpalette_dark[MAX_ITER+2];

palRgb colors_rgb[MAX_ITER+2];


void createPal (unsigned short index, unsigned short r, unsigned short g, unsigned short b)
{
	colors_rgb[index].r=r;
	colors_rgb[index].g=g;
	colors_rgb[index].b=b;
	colorpalette[index]=new QColor (r,g,b);
	colorpalette_dark[index]=new QColor (r*4/5,g*4/5,b*4/5);
	colorpalette_bright[index]=new QColor (min(255,r*5/4),min(255,g*5/4),min(255,b*5/4));
}


void initPalette (int maxiter, bool loaded)
{
	int i,co;
	short r,g,b;
	
	maxiter=fract->validIterations(maxiter);
	
	// delete all QColors
	for (i=0;i<=maxiter;i++)
	{
		if (colorpalette[i])
		{
			delete colorpalette[i];
			colorpalette[i]=NULL;
		}
		if (colorpalette_bright[i])
		{
			delete colorpalette_bright[i];
			colorpalette_bright[i]=NULL;
		}
		if (colorpalette_dark[i])
		{
			delete colorpalette_dark[i];
			colorpalette_dark[i]=NULL;
		}
		
		if (loaded)
		{
			r=colors_rgb[i].r;
			g=colors_rgb[i].g;
			b=colors_rgb[i].b;
		}
		else
		{
			if (maxiter<256) co=256*i/maxiter; else co=i;
			r=(co*3) & 255; g=(co*5) & 255; b=(co*2) & 255;
		}
	
		if (i==maxiter) r=g=b=0;
		
		createPal (i,r,g,b);
	
	}
	
	if (!colorpalette[AREA_BUTTOM]) createPal (AREA_BUTTOM,40,40,40);

}


int validRotate (int grad)
{
	int g=grad % 3600;
	if (g<0) g+=3600;
  return g;
}


int desktopWidth()
{
	return QApplication::desktop()->width();
}


int desktopHeight()
{
	return QApplication::desktop()->height();
}


int min (int a, int b)
{
	return (a < b) ? a : b;
}


int max (int a, int b)
{
	return (a > b) ? a : b;
}


int CalcDeg10 (float g)
{
	return abs((int)(3600*g/PI2)) % 3600;
}


int angle10 (int cx, int cy, int x, int y)
{
	int a;
	int rx=x-cx;
	int ry=y-cy;
	double r=sqrt (rx*rx+ry*ry);

  if (r > 0.0)
  {
    a = CalcDeg10 (atan2 ( ((double)rx) / r, ((double)ry) / r));
    if (x<cx) a=3600-a;
	
    if ( (a-=900) < 0) a+=3600;
		
	}
  else a = CalcDeg10 (0);

  return a;
}


void lowercase (char *s)
{
	int i;
	int l=strlen(s);
	
	for (i=0;i<l;i++) s[i]=tolower(s[i]);
}


void fnum2str (long double n, QString &s, unsigned short maxdecimals)
{
	long double n0=n;
	int i = abs ((int)n0);
	QString s0,tmp;
	
	if (maxdecimals == 0) maxdecimals = 100;
	if (maxdecimals > 100) maxdecimals = 100;	
	
	if (n0>=0.0)
		s0.sprintf ("%d.",i);	// integer part
	else
		s0.sprintf ("-%d.",i);	// -0.xxx

	if (n0<0) n0=-n0;
	n0 = n0 - (long double) i;
	
	for (int j=0;j<maxdecimals;j++)
	{
		if (n0 == 0.0 && j>0) break;
		n0=n0*10.0;
		i=(int)n0;
		tmp.sprintf ("%d",i);
		s0=s0+tmp;
		n0=n0-(long double)i;
	}
	
	// try to make number string shorter
	
	int str_len=s0.length();
	
	for (int j=1;j<=str_len;j++)
	{
		long double f;
		short result=sscanf ((const char *)s0.left(j),"%llf",&f);
		if ( (result==1) && (f == n))
		{
			str_len=j;
			if (!s0.at(str_len-1).isDigit()) str_len++;
			break;
		}
	}
	s=s0.left(str_len);

	//printf ("fnum2str: full     str = %s (%d chars)\n",(const char *)s0,s0.length());
	//printf ("        : stripped str = %s (%d chars)\n",(const char *)s,str_len);
}


short getChecked (QCheckBox *cb)	// return 1 if checked, otherwise 0
{
	short i=0;
	if (cb->isChecked()) i=1;
	return i;
}


bool prefsSetTokenValue (struct Prefs p[], const char *token, PREFVAL value)
{
	int i=0;
	bool success=false;
	
	while (p[i].token != NULL)
	{
		if ( strcasecmp (p[i].token,token) == 0)	// token found
		{
			p[i].num_value=value;
			p[i].valid=true;
			success=true;
		}
		i++;	// next token
	}
	return success;
}


bool prefsGetTokenValue (struct Prefs p[], const char *token, PREFVAL &value)
{
	int i=0;
	bool success=false;
	
	while (p[i].token != NULL)
	{
		if ( strcasecmp (p[i].token,token) == 0)	// token found
		{
			if (p[i].valid)
			{
				value=p[i].num_value;
				success=true;
			}
		}
		i++;	// next token
	}
	return success;
}


bool prefsSetTokenValue (struct Prefs p[], const char *token, char *s)
{
	int i=0;
	bool success=false;
		
	while (p[i].token != NULL)
	{
		if ( (strcasecmp (p[i].token,token) == 0) && p[i].str_value )	// token found
		{
			short len = max (p[i].str_maxlen,1);	// at least one char
			
			strncpy (p[i].str_value,s,len);
			p[i].valid=true;
			success=true;
		}
		i++;	// next token
	}
	return success;
}



bool prefsGetTokenValue (struct Prefs p[], const char *token, char *s)
{
	int i=0;
	bool success=false;
	
	while (p[i].token != NULL)
	{
		if ( (strcasecmp (p[i].token,token) == 0) && p[i].str_value )	// token found
		{
			if (p[i].valid)
			{
				short len = max (p[i].str_maxlen,1);	// at least one char
				strncpy (s,p[i].str_value,len);
				success=true;
			}
		}
		i++;	// next token
	}
	return success;
}

