/***************************************************************************
                          settings.h  -  description
                             -------------------
    begin                : Mon Aug 14 2000
    copyright            : (C) 2000 by Helmut Steger
    email                : hel.steger@rolmail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETTINGS_H
#define SETTINGS_H

#include <qwidget.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qgroupbox.h>
#include <qdial.h>
#include <qlayout.h>
#include <qvalidator.h>

#include "kisomandel.h"
#include "isosettings_form.h"
#include "fractsettings_form.h"
#include "generalsettings_form.h"


class isowin;
class fractal;
class JuliaPreview;



void setButtonColor (QPushButton *b, QColor *c);
void makeColorString (QColor *col, char *s);
bool setColorFromString (QColor &col, char *s);

///////////////////// DoubleNumEdit /////////////////////

class DoubleNumEdit : public QLineEdit
{
	Q_OBJECT
	
	public:
		DoubleNumEdit (QWidget *parent = 0, const char* name = 0, WFlags fl = 0 );
		long double getNumber ();
		void setNumber (long double num, unsigned short maxdecimals=0);
	
	protected:
		void focusOutEvent (QFocusEvent *);
		void keyPressEvent (QKeyEvent *);

	signals:
		void NumberChanged();
	
};


///////////////////// IsoPrefsForm /////////////////////

class IsoPrefs : public IsoPrefsForm
{
	Q_OBJECT

	public:
		IsoPrefs (QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
		void updateValues();
	public slots:
	    virtual void slotIsoHeightChanged();
    	virtual void slotIsoResChanged();
   	    virtual void slotIsoZoomChanged();
   	    virtual void slotAutoHeightChanged();
    	virtual void slotLineWidth();
    	virtual void slotLineColor();
   	    virtual void slotOutlineColor();
        virtual void slotMaxiterColorClicked();
   	    virtual void slotHorRotateChanged();
        virtual void slotVerRotateChanged();
    	virtual void slotCloseClicked();
    private:
    	bool settingUp;
    protected:
    	void keyPressEvent (QKeyEvent *);
    	void closeEvent (QCloseEvent *);
};


///////////////////// FractPrefsForm /////////////////////

class FractPrefs : public FractPrefsForm
{
	Q_OBJECT
	
	public:
		FractPrefs (QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
		~FractPrefs();
		void updateValues();
		bool checkValues();
    	void plotJuliaPreview();
    	void plotJuliaPreview (long double rconst, long double iconst);
	
	public slots:
	    virtual void slotIHeightChanged();
	    virtual void slotImaxChanged();
	    virtual void slotIminChanged();
	    virtual void slotRWidthChanged();
	    virtual void slotRmaxChanged();
	    virtual void slotRminChanged();
        virtual void slotJuliaRconstChanged();
	    virtual void slotJuliaIconstChanged();
	    virtual void slotJuliaConstantsToggle();
    	virtual void slotZoomInOutFactorChanged();
	    virtual void slotZoomInOutIterChanged();
	    virtual void slotApplyClicked();
	    virtual void slotCloseClicked();

	protected:
    	void keyPressEvent (QKeyEvent *);
    	void closeEvent (QCloseEvent *);

    private:
    	long double rmin,rmax,rwidth;
    	long double imin,imax,iheight;
    	long double julia_rconst,julia_iconst;
		JuliaPreview *julia_preview;
};


///////////////////// GeneralPrefsForm /////////////////////

class GeneralPrefs : public GeneralPrefsForm
{
	Q_OBJECT
	
	public:
		GeneralPrefs (QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
		~GeneralPrefs();
		void initValues();
		void initIsoValues();
	
	public slots:
		virtual void slotSelectLineColor();
		virtual void slotSelectOutlineColor();
		virtual void slotSelectMaxiterColor();
	    virtual void slotSelectFractPrefsDir();
	    virtual void slotSelectPaletteDir();
	    virtual void slotSelectPaletteAtStart();
	    virtual void slotGetCurrentIsoSettings();
	    virtual void slotSaveSettings();
	    virtual void slotClose();

	protected:
    	void keyPressEvent (QKeyEvent *);
    	void closeEvent (QCloseEvent *);

    // private:
};




#endif
