# This spec file was generated using Kpp
# If you find any problems with this spec file please report
# the error to ian geiser <geiseri@msoe.edu>

# build with --without ru_ua_layout to disable installation
# of ru_ua XKB layout file

Summary:   Keyboard layout indicator for KDE
Name:      kkbswitch
Version:   1.4.1
Release:   1
License:   GPL
Vendor:    Leonid Zeitlin <lz@europe.com>
Url:       http://kkbswitch.sourceforge.net
Packager:  Leonid Zeitlin <lz@europe.com>
Group:     User Interface/Desktops
Source:    kkbswitch-%{version}.tar.gz
BuildRoot: %{_tmppath}/kkbswitch-root

%description
KKBSwitch is a keyboard layout indicator for KDE. It is useful when
you have configured the XKeyboard extension of your X Server to have more
than one keyboard group (layout), for example US/ASCII and Russian.
KKBSwitch displays an icon in the system tray that indicates which layout
is currently active. Note that KKBSwitch does not help you configure
XKeyboard, it merely serves as the indicator of the current layout. You
still have to configure XKeyboard by editing the XF86Config file. 

%prep
%setup

%build
export KDEDIR=%{_prefix}
# Workaround for legacy auto* tools
#[ -x /usr/bin/autoconf-2.5? ] && ln -s /usr/bin/autoconf-2.5? autoconf
#[ -x /usr/bin/autoheader-2.5? ] && ln -s /usr/bin/autoheader-2.5?
#autoheader
#[ -x /usr/bin/aclocal-1.5 ] && ln -s /usr/bin/aclocal-1.5 aclocal
#[ -x /usr/bin/automake-1.5 ] && ln -s /usr/bin/automake-1.5 automake
#export PATH=`pwd`:$PATH
# End workaround

CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" ./configure \
  --prefix=%{_prefix} $LOCALFLAGS \
  %{?_without_ru_ua_layout:--disable-ru-ua-layout} 

# Setup for parallel builds
numprocs=`egrep -c ^cpu[0-9]+ /proc/stat || :`
if [ "$numprocs" = "0" ]; then
  numprocs=1
fi

make -j$numprocs

%install
make install-strip DESTDIR=$RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT


%files
%doc %{_docdir}/HTML/*/kkbswitch/*
%{_bindir}/kkbswitch
%{_datadir}/applnk/Utilities/kkbswitch.desktop
%{_datadir}/apps/kkbswitch/*
%{_datadir}/apps/kconf_update/kkbswitch.upd
%{_datadir}/apps/kconf_update/kkbswitch_update_14_icons
%{_datadir}/apps/kconf_update/kkbswitch_update_14_options
%{_datadir}/locale/*/LC_MESSAGES/kkbswitch.mo
%{_datadir}/autostart/kkbswitch.desktop
%if %{!?_without_ru_ua_layout:1}
/usr/X11R6/lib/X11/xkb/symbols/ru_ua
%endif
%changelog
* Tue Jun 15 2004 Leonid Zeitlib <lz@europe.com>
- Version 1.4.1

* Sat May  8 2004 Leonid Zeitlin <lz@europe.com>
- Version 1.4
- provide files list explicitly
- --without ru_ua_layout support

* Thu Jan  8 2004 Leonid Zeitlin <lz@europe.com>
- Version 1.3.2

* Sun Nov  2 2003 Leonid Zeitlin <lz@europe.com>
- Version 1.3.1

* Tue Oct 21 2003 Leonid Zeitlin <lz@europe.com>
- Version 1.3
