/***************************************************************************
                          kbconfig.h  -  description
                             -------------------
    begin                : Sun Jul 8 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBCONFIG_H
#define KBCONFIG_H

#include "kbgroup.h"

#include <qptrvector.h>
#include <qvaluevector.h>
#include <kconfig.h>

#define ICONS_SECTION "Icons"
#define OPTIONS_SECTION "Options"

#define FLAG_ICON_WIDTH 21
#define FLAG_ICON_HEIGHT 14

class KGlobalAccel;

typedef QPtrVector<KBGroup> KBGroupVector;

/**The class that stores configuration information of KBSwitch
  *@author Leonid Zeitlin
  */

class KBConfig {
public:
  enum IconStyle { ICON_FLAG, ICON_CODE, ICON_CODE_AND_FLAG };	
  enum GroupScope { SCOPE_GLOBAL, SCOPE_CLASS, SCOPE_WINDOW };
private:
  KBGroupVector m_groups;
  bool m_toggle_mode;
  int m_default_groupno;
  //bool m_perwindow_group;
  GroupScope m_group_scope;
  bool m_autostart;
  bool m_use_shortcuts;
  IconStyle m_icon_style;
  KGlobalAccel *m_keys;
public: 
	KBConfig();
	~KBConfig();
	int groupCount() { return m_groups.count(); };
	KBGroup *getGroup(int groupno) { return m_groups[groupno]; };
	bool toggle_mode() {return m_toggle_mode; };
  /** No descriptions */
  void set_toggle_mode(bool value) {m_toggle_mode = value; };
  int default_groupno() { return m_default_groupno; };
  void set_default_groupno(int value) { m_default_groupno = value; };
  /*bool perwindow_group() { return m_perwindow_group; };
  void set_perwindow_group(int value) { m_perwindow_group = value; };*/
  GroupScope group_scope() { return m_group_scope; }
  void set_group_scope(GroupScope value) { m_group_scope = value; }
  bool autostart() { return m_autostart; }
  void set_autostart(bool value) { m_autostart = value; }
  IconStyle icon_style() { return m_icon_style; }
  void set_icon_style(IconStyle value) { m_icon_style = value; }
  bool use_shortcuts() { return m_use_shortcuts; }
  void set_use_shortcuts(bool value) { m_use_shortcuts = value; }
  KGlobalAccel *keys() { return m_keys; }
  /** Load the KBSwitch configration from the application KConfig object */
  void load(KConfig *config);
  /** Save the KBSwitch configration to the application KConfig object */
  void save(KConfig *config);
  /** No descriptions */
  /*void notifyChanged();*/
  /*static QString entryForGroup(int i) {
    return QString("Group%1").arg(i+1);
  }*/
  void drawIcons(IconStyle icon_style, QValueVector<QPixmap> *icons,
    QStringList *iconpaths);
  void checkKeysEnabled();
  int getNextGroup(int groupno) {
    return groupno >= groupCount() - 1 ? 0 : groupno + 1;
  }  
private: // Private methods
  /** No descriptions */
  //void guessGroupPixmaps();
  /** No descriptions */
  //void drawDefaultPixmaps();
  /** No descriptions */
  //void loadConfiguredPixmaps(KConfig *config);
  void drawFlagPixmap(QPixmap &pix, QString &path, const QString &code,
    int group, KConfig *config);
  void drawCodePixmap(QPixmap &pix, const QString &code);
  void drawCodeAndFlagPixmap(QPixmap &pix, QString &path,
    const QString &countryCode, const QString &langCode, int group,
    KConfig *config);
  void drawDefaultPixmap(QPixmap &pix, int group);
  bool getGroupImage(QImage &img, QString &path, const QString &code, int group,
    KConfig *config);
};

#endif
