/***************************************************************************
                          boldmenuitem.h  -  description
                             -------------------
    begin                : Sat Sep 1 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BOLDMENUITEM_H
#define BOLDMENUITEM_H

#include <qmenudata.h>

/**A custom menu item that can display its text in bold
  *@author Leonid Zeitlin
  * 02.09.2001: somehow I cannot make it work. The item looks ok when not
  * selected, but appears empty when selected. I have a suspicion that this
  * is a problem with some KDE styles (B3 in particular), the style doesn't
  * paint custom menu items correctly. With some other styles, such as Qt built-in
  * Windows style, everything works correctly. I suspend the work on this for the
  * time being...
  */

class BoldMenuItem : public QCustomMenuItem  {
private:
  QString m_text;
  QColor m_active_text_color;
  bool m_bold;
  QSize m_size;
public: 
	BoldMenuItem(const QString &text, const QColor &active_text_color, bool bold = false);
	~BoldMenuItem();
	QString& text() { return m_text; };
	void setText(const QString& value) { m_text = value; };
	bool bold() { return m_bold; };
	void setBold(bool value) { m_bold = value; };
	virtual void paint(QPainter* painter, const QColorGroup& /*cg*/,
	  bool act, bool /*enabled*/, int x, int y, int w, int h);
	virtual void setFont(const QFont& font);
	virtual QSize sizeHint() { return m_size; };
};

#endif
