/***************************************************************************
 *   Copyright (C) 2004 by Michael Vonrden                                *
 *   klipoquery@michael-vonrueden.de                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qpixmap.h>
#include <qstringlist.h>
#include <qtooltip.h> 
#include <qdict.h> 

#include <kaboutdata.h> 
#include <kaboutdialog.h> 
#include <kaboutapplication.h> 
#include <kglobal.h>
#include <klocale.h>
#include <kconfig.h>
#include <kapplication.h>
#include <kmessagebox.h>
#include <kurlpixmapprovider.h> 
#include <klistview.h> 

#include "klipoquery.h"
#include "klipoqueryaction.h"
#include "klipoquerypreferences.h"

KlipOQuery::KlipOQuery(const QString& configFile, Type type, int actions, QWidget *parent, const char *name)
    : KPanelApplet(configFile, type, actions, parent, name)
{
    // Get the current application configuration handle
   config = new KlipOQueryConfig();
  
   appletBox = new QVBoxLayout(this);

   actionButton  = new QPushButton(this);
   this->connect(actionButton,SIGNAL (clicked()),this,SLOT (getInformation()));
   generatePopupMenu();
   setBoxContent();
   appletBox->add(actionButton);

   
}


KlipOQuery::~KlipOQuery()
{
	config->~KlipOQueryConfig();
// 	delete config;
// 	delete  actionButton;
// 	delete appletBox;
//     	delete menu;
// 
}

void KlipOQuery::refresh()
{


	setBoxContent();
	generatePopupMenu();

}


void KlipOQuery::setBoxContent()
{
// look for suitable icon for the Url of the service
KURLPixmapProvider *pixmapProvider=new KURLPixmapProvider();
// set this pixmap to the button
actionButton->setPixmap(pixmapProvider->pixmapFor(config->getServiceURL(),16));
// set the tooltip
 QToolTip::add( this, config->getServiceName()+"\n"+config->getServiceDescription());
actionButton->adjustSize();

delete pixmapProvider;
}

void KlipOQuery::getInformation()
{
config->updateRank();
generatePopupMenu();
KlipOQueryAction *action = new KlipOQueryAction(config->getServiceURL(),config->getBrowser());
delete action;
}

void KlipOQuery::generatePopupMenu()
{

menu = new KPopupMenu(this);		
QDict<KPopupMenu> groupList(123,true);
QValueList<int> groupIDs = config->getGroups();
		
// Setup the submenus
for ( QValueList<int>::Iterator it = groupIDs.begin(); it != groupIDs.end(); ++it )
{
	groupList.insert(QString::number(*it),new KPopupMenu(this));
}
			
//get the registered Services
QValueList<int> serviceIDs = config->getRegisteredServices();

// handle the Urlicons
KURLPixmapProvider *pixmapProvider=new KURLPixmapProvider();

// add Services to the submenus
for ( QValueList<int>::Iterator it = serviceIDs.begin(); it != serviceIDs.end(); ++it )
{
	int id = *it;
	KPopupMenu *submenu = groupList.find(config->getServiceGroup(id));

	if (submenu)
	{
		submenu->insertItem(QIconSet(pixmapProvider->pixmapFor(config->getServiceURL(id),16)),config->getServiceName(id)+"\t"+config->getServiceDescription(id),id);
	}
	else
	{
		menu->insertItem(QIconSet(pixmapProvider->pixmapFor(config->getServiceURL(id),16)),config->getServiceName(id)+"\t"+config->getServiceDescription(id),id);
	}
	
}
// add the submenu to the menu
for ( QValueList<int>::Iterator it = groupIDs.begin(); it != groupIDs.end(); ++it )
{

	;
	KPopupMenu *submenu = groupList.find(QString::number(*it));
	menu->insertItem(config->getGroupName(*it),submenu);
}

//insert seperator
int top = config->getTop();
if (top>0)
menu->insertTitle(i18n("Your Top")+QString::number(config->getTop())+" "+i18n("Services"));
//construct the top listing
QValueList<int> topRanks = config->getTopRanking();
for ( QValueList<int>::Iterator id = topRanks.begin(); id != topRanks.end(); ++id )
	{	
		menu->insertItem(QIconSet(pixmapProvider->pixmapFor(config->getServiceURL(*id),16)),config->getServiceName(*id)+"\t "+config->getServiceDescription(*id),*id);
	}	

delete pixmapProvider;
}
void KlipOQuery::mousePressEvent(QMouseEvent* e)
{
 	refresh();
	if (e->button() == RightButton)
	{
		// get the clicked item
		int pressedItem =menu->exec(mapToGlobal(e->pos()));
		//if outside the menue, perform no action
		if (pressedItem!=-1)
		{
		config->setDefault(pressedItem);
		setBoxContent();

		;
		getInformation();
		
		}

   	 }
	 
}

void KlipOQuery::wheelEvent(QWheelEvent* e)
{
	//remove the tooltip
	QToolTip::remove(this);
	// get the registered services
	QValueList<int> serviceIDs = config->getRegisteredServices();
	// get the pointer to the current item in list
	QValueList<int>::Iterator it = serviceIDs.find(config->getActiveServiceID());
	
	//if scrolling north
	// note: the diffenrent iterator handling is because it.end() points to past item of the lastitem in the list
	if (e->delta()>0)
	{
		it++;
		if (it==serviceIDs.end())
		{
			it=serviceIDs.begin();
		}
		config->setDefault(*it);
	}
	//if scrolling south
	else
	{
		if (it==serviceIDs.begin())
		{
			it=serviceIDs.end();
			it--;
		}
		else
		{
			it--;
		}
		config->setDefault(*it);
	}
	
	// perform layout handling
	setBoxContent();

}

void KlipOQuery::about()
{
  KAboutData *klipOQueryAboutData = new KAboutData(
  	"KlipOQuery",
 	 I18N_NOOP("KlipOQuery"),
  	"0.2.4",
  	"KlipOQuery bridges the Klippercontent easily with the web. \n\nBy choosing a service from KlipOQuery, the Klipperitem will be appended to the URL (by exchanging the %s placeholder) of the choosen service.",
  	KAboutData::License_GPL_V2,
  	"(c) 2004 , Michael Vonrueden");
	
  	klipOQueryAboutData->addAuthor("Michael Vonrueden", "","kde@michael-vonrueden.de","http://www.michael-vonrueden.de/klipoquery/");
 

	KAboutApplication *klipOQueryAbout = new KAboutApplication(klipOQueryAboutData);
	klipOQueryAbout->show();


}
void KlipOQuery::help()
{
   KMessageBox::information(0,i18n("Help is available at http://www.michael-vonrueden.de/klipoquery"));
}


void KlipOQuery::preferences()
{
	config->save();
	
	KlipOQueryPreferences *prefs = new KlipOQueryPreferences(config);	 

}

int KlipOQuery::widthForHeight(int height) const
{
	actionButton->adjustSize();
return actionButton->width() ;

}

int KlipOQuery::heightForWidth(int width) const
{
	actionButton->adjustSize();
   return actionButton->height(); 
}

void KlipOQuery::resizeEvent(QResizeEvent *e)
{
}


extern "C"
{
    KPanelApplet* init( QWidget *parent, const QString& configFile)
    {
        KGlobal::locale()->insertCatalogue("KlipOQuery");
        return new KlipOQuery(configFile, KPanelApplet::Normal,
                             KPanelApplet::About | KPanelApplet::Help | KPanelApplet::Preferences,
                             parent, "KlipOQuery");
    }
}
