/***************************************************************************
 *   Copyright (C) 2004 by Michael Vonrden                                *
 *   mail@michael-vonrueden.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qurl.h> 

#include <dcopclient.h>
#include <kmessagebox.h>
#include <kprocess.h>
#include <kurl.h> 
#include <krun.h> 


#include "klipoqueryaction.h"

KlipOQueryAction::KlipOQueryAction(QString URL)
{
	startProcess(URL);
}
KlipOQueryAction::KlipOQueryAction(QString URL, QString browser)
{
	startProcess(URL, browser);
}

KlipOQueryAction::~KlipOQueryAction()
{
	
}

QString KlipOQueryAction::getClipBoardContent()
{
DCOPClient *client = new DCOPClient();
client->attach();
QByteArray  data, reply_data;    // also prepare a byte array
                          // for the reply
QCString reply_type; // will contain the type of the reply
QDataStream arg(data, IO_WriteOnly);


if (!client->call("klipper","klipper","getClipboardContents()",data,  reply_type,reply_data))
            		// signature of method to handle data and answer
                 	// sent data
                   	// type of data contained in the answer
                   	// the answer
{
	delete client;
	return "";
}  
else 
{
   QDataStream answer(reply_data, IO_ReadOnly);
   if (reply_type == "QString") 
   {
     	QString result;
	answer >> result;
	delete client;
   	return result;
   }
    else
   {
	delete client;
      	return "";
   }
}
}

void KlipOQueryAction::startProcess(QString URL, QString app)
{   

// get the clipboard content via  DCOP
QString query = getClipBoardContent();
// transform in a valid url Query
query=KURL::encode_string(query);
// append the query
URL.replace("%s",query);


if (app=="")
KRun::runURL(KURL(URL), "text/html");

else
{
KRun::shellQuote(URL);
KRun::runCommand(app+" "+KURL(URL).url());
}
	   
}

