/***************************************************************************
 *   Copyright (C) 2004 by Michael Vonrden                                *
 *   klipoquery@michael-vonrueden.de                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qmap.h> 
#include <qmemarray.h> 
#include <qmap.h> 
#include <qvaluelist.h> 
#include "klipoqueryconfig.h"


KlipOQueryConfig::KlipOQueryConfig()
{
	appletConfig = new KConfig("klipoqueryrc");
	SETTINGS = "Settings";
	GROUPS="Groups";
}


KlipOQueryConfig::~KlipOQueryConfig()
{
	appletConfig->~KConfig();
}

void KlipOQueryConfig::reload()
{
	appletConfig->rollback();
	appletConfig->sync();
	appletConfig->reparseConfiguration();

}
void KlipOQueryConfig::save()
{
	appletConfig->sync();
}
	
int KlipOQueryConfig::addService(int group, QString name, QString description, QString URL)
{
	QValueList<int> allServices = getAllServices();
	qHeapSort(allServices);
	int endItem = allServices.last();
	endItem=endItem+1;
	allServices.append(endItem);
	appletConfig->setGroup("Service"+QString::number(endItem));
	appletConfig->writeEntry("Name",name);
	appletConfig->writeEntry("Description",description);
	appletConfig->writeEntry("URL",URL);
	appletConfig->writeEntry("Group",group);
	appletConfig->writeEntry("Rank",0);
	
	appletConfig->setGroup(SETTINGS);
	appletConfig->writeEntry("AllServices",allServices);
	return endItem;
}
	
void KlipOQueryConfig::updateService(int id, QString name, QString description, QString URL)
{
	appletConfig->setGroup("Service"+QString::number(id));
	appletConfig->writeEntry("Name",name);
	appletConfig->writeEntry("Description",description);
	appletConfig->writeEntry("URL",URL);
}

void KlipOQueryConfig::deleteService(int id)
{
	appletConfig->deleteGroup("Service"+QString::number(id));
	QValueList<int> registeredServices = getRegisteredServices();
	QValueList<int> allServices = getAllServices();
	registeredServices.remove(id);
	allServices.remove(id);
	appletConfig->setGroup(SETTINGS);
	appletConfig->writeEntry("AllServices",allServices);
	appletConfig->writeEntry("RegisteredServices",allServices);
	
}
void KlipOQueryConfig::setDefault(int id)
{
	appletConfig->setGroup(SETTINGS);
	appletConfig->writeEntry("ActiveService",id);
}

bool KlipOQueryConfig::isRegisteredService(int id)
{
	QValueList<int> registeredServices = getRegisteredServices();
	int occurence = registeredServices.findIndex(id);
	if (occurence!=-1)
	return true;
	else
	return false;

}

void KlipOQueryConfig::addToRegisteredServices(int id)
{
	QValueList<int> registeredServices = getRegisteredServices();
	registeredServices.insert(registeredServices.end(),id);
	appletConfig->setGroup(SETTINGS);
	qHeapSort(registeredServices);
	appletConfig->writeEntry("RegisteredServices",registeredServices);
}

void KlipOQueryConfig::removeFromRegisteredServices(int id)
{
	QValueList<int> registeredServices = getRegisteredServices();
	registeredServices.remove(id);
	appletConfig->setGroup(SETTINGS);
	qHeapSort(registeredServices);
	appletConfig->writeEntry("RegisteredServices",registeredServices);
}

void KlipOQueryConfig	::setTop(int n)
{
	appletConfig->setGroup(SETTINGS);
	appletConfig->writeEntry("TopEntries",n);
}

int  KlipOQueryConfig::getTop()
{
	appletConfig->setGroup(SETTINGS);
	return appletConfig->readNumEntry("TopEntries",4);
}
	
QValueList<int> KlipOQueryConfig::getTopRanking()
{
	//get the number of requested top items
	int top=getTop();
	QValueList<int> allServices = getAllServices();
	QMap <int,int> ranking;
	
	for ( QValueList<int>::Iterator item = allServices.begin(); item != allServices.end(); ++item )
	{
		ranking.insert(*item,getServiceRank(*item));
	}	

	//the top items list
	QValueList<int> topServices;
	int highestRate=0;
	int currentId;
	// get the top rankings
	for (int j=0; j<top; j++)
	{
		for (QMap<int,int>::Iterator item = ranking.begin();item != ranking.end();item++)
		{
			if (item.data()>=highestRate && isRegisteredService(item.key()))
			{
				highestRate=item.data();
				currentId=item.key();
			}
		}
		ranking.remove(currentId);
		
		//dont append a service with rank 0
// 		if (highestRate!=0)
			topServices.append(currentId);
		highestRate=0;
	}

	return topServices;

}

void KlipOQueryConfig::updateRank(int id)
{
	if (id==-1)
	id=getActiveServiceID();
	
	appletConfig->setGroup("Service"+QString::number(id));
	int rank = appletConfig->readNumEntry("Rank",-1);
	if (rank!=-1)
	{
		rank++;
		appletConfig->writeEntry("Rank",rank);
	}
	else
	{
		appletConfig->writeEntry("Rank",0);
	}
}
int KlipOQueryConfig::getActiveServiceID()
{
	appletConfig->setGroup(SETTINGS);
	return appletConfig->readNumEntry("ActiveService",-1);
}

QString KlipOQueryConfig::getServiceName(int  id)
{
	if (id==-1)
	id=getActiveServiceID();
	
	appletConfig->setGroup("Service"+QString::number(id));
	return appletConfig->readEntry("Name","-1");
}

QString KlipOQueryConfig::getServiceURL(int  id)
{
	if (id==-1)
	id=getActiveServiceID();
	
	appletConfig->setGroup("Service"+QString::number(id));
	return appletConfig->readEntry("URL","-1");
}

QString KlipOQueryConfig::getServiceDescription(int id)
{
	if (id==-1)
	id=getActiveServiceID();
	
	appletConfig->setGroup("Service"+QString::number(id));
	return appletConfig->readEntry("Description","-1");
}

QValueList<int> KlipOQueryConfig::getRegisteredServices()
{
	appletConfig->setGroup(SETTINGS);
	return appletConfig->readIntListEntry("RegisteredServices");
}

QValueList<int> KlipOQueryConfig::getAllServices()
{
	appletConfig->setGroup(SETTINGS);
	return appletConfig->readIntListEntry("AllServices");
}

QString KlipOQueryConfig::getServiceGroup(int id)
{
	appletConfig->setGroup("Service"+QString::number(id));
	return appletConfig->readEntry("Group","-1");
}

int KlipOQueryConfig::getServiceRank(int id)
{
	appletConfig->setGroup("Service"+QString::number(id));
	return appletConfig->readNumEntry("Rank",-1);
}
	
QValueList<int> KlipOQueryConfig::getGroups()
{
	appletConfig->setGroup(SETTINGS);
	return appletConfig->readIntListEntry("Groups");
}

int KlipOQueryConfig::addGroup(QString name)
{
	QValueList<int> groups = getGroups();
	qHeapSort(groups);
	int endItem = groups.last();
	endItem=endItem+1;
	groups.append(endItem);
	appletConfig->setGroup(GROUPS);
	appletConfig->writeEntry(QString::number(endItem),name);
	appletConfig->setGroup(SETTINGS);
	appletConfig->writeEntry("Groups",groups);
	return endItem;
	
}

void KlipOQueryConfig::deleteGroup(int id)
{
		QValueList<int> groups = getGroups();
		groups.remove(id);
		qHeapSort(groups);
		appletConfig->setGroup(GROUPS);
		appletConfig->deleteEntry(QString::number(id));
		appletConfig->setGroup(SETTINGS);
		appletConfig->writeEntry("Groups",groups);
}		
void KlipOQueryConfig::renameGroup(int id, QString name)
{
	appletConfig->setGroup(GROUPS);
	appletConfig->writeEntry(QString::number(id),name);
}
	
QString KlipOQueryConfig::getGroupName(int id)
{
	appletConfig->setGroup(GROUPS);
	return appletConfig->readEntry(QString::number(id),"-1");
}

QString KlipOQueryConfig::getBrowser()
{
	appletConfig->setGroup(SETTINGS);
	return appletConfig->readEntry("browser","");
	
}

void KlipOQueryConfig::setBrowser(QString browser)
{
	appletConfig->setGroup(SETTINGS);
	appletConfig->writeEntry("browser",browser);
}
