/***************************************************************************
 *   Copyright (C) 2004 by Michael Vonrden                                *
 *   klipoquery@michael-vonrueden.de                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KLIPOQUERYCONFIG_H
#define KLIPOQUERYCONFIG_H
#include <kconfig.h> 
#include <qstringlist.h> 

/**
@author Michael Vonrden
*/
 class KlipOQueryConfig
 {
 
 public:
 
/**
  *Constructs a Custom Config for the KlipOQuery
 */
 KlipOQueryConfig();
 
/**
  *Deconstructs a Custom Config for the KlipOQuery
 */
 ~KlipOQueryConfig();
 
/**
 invokes load the config from disk again, no changes will be written
 */
void reload();

/**
* saves the config to disk
**/
void save();
 
/**
 * appends a new Service to the Configfile
 *@param name The Name for the Service (e.g Dict Leo)
 *@param description The discrption of the service (e.g Translates german to english)
 *@URL The Url to service (e.g  http://dict.leo.org/?search=%s )
 */
int  addService(int group, QString name, QString description, QString URL);
 
/**
 *updates a  Service to the Configfile
 * appends a new Service to the Configfile
 *@param id The id for this service
 *@param name The Name for the Service (e.g Dict Leo)
 *@param description The discrption of the service (e.g Translates german to english)
 *@URL The Url to service (e.g  http://dict.leo.org/?search=%s )
 */
 void updateService(int id , QString name, QString description, QString URL);
 
/**
 *delets  a  Service by id
 *@param id The id for this service
 */
 void deleteService(int id);
 
/**
 *set a service as default  Service  by id
 *@param id The id for this service
 */
 void setDefault(int id);
 
 /** 
 * set value for the n top ranked 
 * services
 **/
 void setTop(int n);
 
 /**
 * return the value for top rankes
 **/
 int getTop();
 /**
 *set the new rank for a given id
 *@param id The id for this service
 */
 void updateRank(int id=-1);
/**
 *appends a service to the registered Services
 *@param id The id for this service
 */
 void addToRegisteredServices(int id);

/**
 *delets a service from the registered Services
 *@param id The id for this service
 */
 void removeFromRegisteredServices(int id);
 
  /**
 *checks if a service is in the registered Services
 *@param id The id for this service
 */
 bool isRegisteredService(int id);


 /**  
 *returns the to ranked services
 @param top The number of services for the ranking
 */
 QValueList<int> getTopRanking();
 
/**  
 *returns the registered Services
 */
 QValueList<int> getRegisteredServices();
 
 /**  
 *returns all Services
 */
 QValueList<int> getAllServices();
 
/**
 *returns the default Serviceid (or the active one)
 */
 int getActiveServiceID();
 
/**
 *returns the URL for a given Serviceid (default is the active one)
 *@param id The id for this service
 */
 QString getServiceURL(int id = -1);
 
/**
 *returns the name for a given Serviceid (default is the active one)
 *@param id The id for this service
 */
 QString getServiceName(int id = -1);
 
/**
 *returns the description for a given Serviceid (default is the active one)
 *@param id The id for this service
 */
 QString getServiceDescription(int id = -1);
 
 /**
 *returns the group for a given Serviceid (default is the active one)
 *@param id The id for this service
 */
 QString getServiceGroup(int id = -1);
 
 /**
 *returns the Rank of  a given Serviceid (default is the active one)
 *@param id The id for this service
 */
  int  getServiceRank(int id = -1);
 
  
  /** 
  * renames a group
  **/
  void renameGroup(int id, QString name);
  
  /** 
  * adds a group
  *@name the new groupname
  *@return the id for this new group
  **/
  
  int addGroup(QString name);
  
  /**
  * deletes a group
  **/
  void deleteGroup(int id);
 /**  
 *returns the groupids
 */
 QValueList<int> getGroups();
 
 /**
 *returns the name for the groupname by its id 
 *@param id The id for this service
 */
 QString getGroupName(int id = -1);
 
 /**
 * returns the default browser
 **/
 QString getBrowser();
  
  /**
 * @browser sets the  default browser
 **/
 void setBrowser(QString browser);
 
 private:
 
/**
 *writes the Config to Disk
 */
void writeOut();

/**
*the actual Kconfig
*/

KConfig *appletConfig;
QString  SETTINGS, GROUPS ;

 };
#endif
