/***************************************************************************
 *   Copyright (C) 2004 by Michael Vonrden                                *
 *   mail@michael-vonrueden.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qdict.h> 
#include <qpushbutton.h> 
#include <qstringlist.h>
#include <qlayout.h> 
#include <qpixmap.h>
#include <qpopupmenu.h>

#include <kmessagebox.h>
#include <kurlpixmapprovider.h> 
#include <kdialogbase.h> 
#include <klocale.h> 

#include "klipoquerypreferences.h"

KlipOQueryPreferences::KlipOQueryPreferences( KlipOQueryConfig *config ,QWidget *parent, const char *name ) 
	: QWidget(parent, name)
{

 	this->newConfig = config;


	KDialogBase *kdialog = new KDialogBase(KDialogBase::Tabbed, i18n("Confguration"),KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok);
	
	services = kdialog->addVBoxPage( i18n("Services") );
	general =  kdialog->addVBoxPage( i18n("General") );
	preferences = new KListView(services);
	
	createListView();
	createEditArea();
	createGeneralTab();

	kdialog->setMinimumWidth(500);
	kdialog->raise();
	kdialog->show();
	
 	connect(nameField,SIGNAL( textChanged(const QString&)), this, SLOT (changeServiceName(const QString&)));
	connect(descriptionField,SIGNAL( textChanged(const QString&)), this, SLOT (changeServiceDescription(const QString&)));
	connect(urlField,SIGNAL( textChanged(const QString&)), this, SLOT (changeServiceURL(const QString&)));
	connect(activateCheckBox,SIGNAL( clicked()), this, SLOT(activateService()));
	
	//Listview related
	connect(preferences,SIGNAL ( executed(QListViewItem*) ),this,SLOT (listItemExecuted(QListViewItem*)));
	connect(preferences,SIGNAL ( contextMenu(KListView*, QListViewItem*, const QPoint&)), this, SLOT(handleContextMenu(KListView*, QListViewItem*, const QPoint& )));
	
	//Generaltab related
	connect(topSlider, SIGNAL (valueChanged(int)), this, SLOT (setTopRanking(int )));
	connect(browserField,SIGNAL( textChanged(const QString&)), this, SLOT (changeBrowser(const QString&)));
	
	
	connect(kdialog, SIGNAL(cancelClicked()),this, SLOT(resetConfig()));
	enableEditArea(false);
	

	
}
KlipOQueryPreferences::~KlipOQueryPreferences()
{
delete newConfig;
delete activeListViewItem;
delete services;
delete general;
delete preferences;
delete nameField;
delete descriptionField;
delete urlField;
delete nameLabel;
delete descriptionLabel;
delete urlLabel;
delete activateLabel;
delete activateCheckBox;
delete topSlider;
delete sliderBox;
delete browserBox;
delete topRankingLabel;
delete browserField;
delete browserLabel;
}
void KlipOQueryPreferences::listItemExecuted(QListViewItem *item)
{
	activeListViewItem = item;
	
	if (!isServiceGroup())
	{
		enableEditArea(true);
		
		
		nameField->setText(item->text(0));
		descriptionField->setText(item->text(1));
		urlField->setText(item->text(3));
		if (item->text(2)=="*")
		{
			activateCheckBox->setChecked(true);
			activateCheckBox->setText(i18n("Yes"));
		}
		else
		{
			activateCheckBox->setChecked(false);
			activateCheckBox->setText(i18n("No"));
		}
	}
	else
	{	
		enableEditArea(true);
		nameField->setText(item->text(0));
		descriptionField->setText(item->text(1));
		urlField->setText("");
		
		descriptionField->setEnabled(false);
		urlField->setEnabled(false);
		activateCheckBox->setChecked(true);
		activateCheckBox->setEnabled(false);
		activateCheckBox->setText("");
	}
}

void KlipOQueryPreferences::handleContextMenu(KListView *list, QListViewItem *item, const QPoint &point)
{
	QPopupMenu *context = new QPopupMenu();
	if (item==0)
	{
		context->insertItem(i18n("New Group"),1);
		list=this->preferences;
	}
	
	
	else if (item->parent()==0)
	{
		context->insertItem(i18n("New Group"),1);
		context->insertItem(i18n("New Service"),2);
		context->insertItem(i18n("Delete Group"),3);
		
	}
	else
	{
		context->insertItem(i18n("Delete Service"),4);
	}
	int action = context->exec(point);
	
if (action==1)
{
	int id =newConfig->addGroup(i18n("New Group"));
	KListViewItem *newItem = new KListViewItem(list,newConfig->getGroupName(id),i18n("Group"),"","",QString::number(id));
	list->setSelected(newItem, true);
	listItemExecuted(newItem);
}
if (action==2)
{
		int id =newConfig->addService((item->text(4)).toInt(),i18n("New Service"),i18n("Description"), "");
		newConfig->addToRegisteredServices(id);
		KListViewItem *newItem = new KListViewItem(item,newConfig->getServiceName(id),newConfig->getServiceDescription(id),"*",newConfig->getServiceURL(id),QString::number(id));
		list->setSelected(newItem, true);
		listItemExecuted(newItem);
		list->setOpen(newItem->parent(),true);
}
if (action==3)
{
	
	if (item->firstChild()!=0)
	{
		if (KMessageBox::warningYesNo(0, i18n("This Group is not empty.\n Do you want to delete all services in this group?\n"), i18n("Service Deletion"))==3)
		{
			QListViewItem *itemToDelete = item->firstChild();;
			 while (itemToDelete!=0)
			{
				newConfig->deleteService((itemToDelete->text(4)).toInt());
				
				itemToDelete =itemToDelete->nextSibling();
			 }
			
			 
			 newConfig->deleteGroup(item->text(4).toInt());
			 item->~QListViewItem();
		}
	}
	else
	{
		newConfig->deleteGroup(item->text(4).toInt());
		item->~QListViewItem();
	}
	list->setSelected(list->firstChild(), true);
	listItemExecuted(list->firstChild());
}
	
if (action==4)
{
	if (KMessageBox::warningYesNo(0, i18n("Do you really want to delete the Service:\n"+i18n(item->text(0))), i18n("Service Deletion"))==3)
    {
    	list->setSelected(item->parent(), true);
	listItemExecuted(item->parent());
    	newConfig->deleteService(item->text(4).toInt());
	item->~QListViewItem();
   }
 
	
		
}
}
void KlipOQueryPreferences::enableEditArea(bool enable)
{
	nameField->setEnabled(enable);
	descriptionField->setEnabled(enable);
	urlField->setEnabled(enable);
	activateCheckBox->setEnabled(enable);
}

void KlipOQueryPreferences::changeServiceName(const QString &text)
{
	activeListViewItem->setText(0,text);
	updateService();
	
}
void KlipOQueryPreferences::changeServiceDescription(const QString &text)
{
	activeListViewItem->setText(1,text);
	updateService();
	
}
void KlipOQueryPreferences::changeServiceURL(const QString &text)
{
	activeListViewItem->setText(3,text);
	updateService();
	
}

void KlipOQueryPreferences::changeBrowser(const QString &browser)
{
	newConfig->setBrowser(browser);
}

void KlipOQueryPreferences::activateService()
{
	if (activateCheckBox->isChecked())
	{
		newConfig->addToRegisteredServices((activeListViewItem->text(4)).toInt());
		activeListViewItem->setText(2,"*");
		activateCheckBox->setText(i18n("Yes"));
	}
	else
	{
		newConfig->removeFromRegisteredServices((activeListViewItem->text(4)).toInt());
		activeListViewItem->setText(2,"");
		activateCheckBox->setText(i18n("No"));
	}
}
	

void KlipOQueryPreferences::resetConfig()
{
	newConfig->reload();
	
}
void KlipOQueryPreferences::updateService()
{
	if (!isServiceGroup())
	{
		QString name, description, url;
		int id;
		name=activeListViewItem->text(0);
		description=activeListViewItem->text(1);
		url=activeListViewItem->text(3);
		id =(activeListViewItem->text(4)).toInt();
		newConfig->updateService(id, name, description,url);
	}
	else
	{
		newConfig->renameGroup((activeListViewItem->text(4)).toInt(), activeListViewItem->text(0));
	}
}

bool KlipOQueryPreferences::isServiceGroup()
{
	if (activeListViewItem->parent()==0)
	{
		return true;
		
	}
	else
	{
		return false;
	}
}


void KlipOQueryPreferences::createEditArea()
{
	QWidget *editArea = new QWidget(services);
	QGridLayout *editAreaLayout = new QGridLayout(editArea ,2,4, 3, 5);
	// init Labels for fields
	nameLabel = new QLabel(i18n("Name: "),editArea );
	
	descriptionLabel = new QLabel(i18n("Description:"), editArea);
	urlLabel = new QLabel(i18n("URL:"), editArea);
	activateLabel = new QLabel(i18n("Active:"), editArea);
	
	// init LineEdits for Service Change Area
	nameField = new QLineEdit(editArea);
	descriptionField = new QLineEdit(editArea);
	urlField = new QLineEdit(editArea);
	
	// init checkbox for service activation
	activateCheckBox = new QCheckBox("", editArea);
	
	editAreaLayout->addWidget(nameLabel,0,0);
	editAreaLayout->addWidget(nameField,0,1);
	editAreaLayout->addWidget(descriptionLabel,1,0);
	editAreaLayout->addWidget(descriptionField,1,1);
	editAreaLayout->addWidget(urlLabel,2,0);
	editAreaLayout->addWidget(urlField,2,1);
	editAreaLayout->addWidget(activateLabel,3,0);
	editAreaLayout->addWidget(activateCheckBox,3,1);	
		
	
	
}

void KlipOQueryPreferences::createListView()
{
preferences->setSelectionMode( QListView::Single );
preferences->setRootIsDecorated ( true );
preferences->addColumn( i18n("Name"));
preferences->addColumn( i18n("Description") );
preferences->addColumn( i18n("Activated") );

QValueList<int> groupIDs = newConfig->getGroups();
QDict<KListViewItem> groupList(groupIDs.size(),true);

		
		// Setup the popupmenu
		for ( QValueList<int>::Iterator it = groupIDs.begin(); it != groupIDs.end(); ++it )
		{
			groupList.insert(QString::number(*it),new KListViewItem(preferences,newConfig->getGroupName(*it),i18n("Group"),"","",QString::number(*it)));
		}
			
QValueList<int> serviceIDs = newConfig->getAllServices();
		KURLPixmapProvider *pixmapProvider=new KURLPixmapProvider();

		for ( QValueList<int>::Iterator it = serviceIDs.begin(); it != serviceIDs.end(); ++it )
		{
			int id = *it;

			QString activated="";;
			if (newConfig->isRegisteredService(id))
			{
				activated="*";
			}
			
			
			KListViewItem *parent = groupList.find(newConfig->getServiceGroup(id));

			if (parent)
			{
				KListViewItem *element = new KListViewItem(parent,newConfig->getServiceName(id),newConfig->getServiceDescription(id),activated,newConfig->getServiceURL(id),QString::number(id));
				element->setPixmap(0,pixmapProvider->pixmapFor(newConfig->getServiceURL(id),16));
			}
			else
			{
				KListViewItem *element = new KListViewItem(preferences,newConfig->getServiceName(id),newConfig->getServiceDescription(id),activated,newConfig->getServiceURL(id),QString::number(id));
				element->setPixmap(0,pixmapProvider->pixmapFor(newConfig->getServiceURL(id),16));
			}
			
			
			
		}

preferences->adjustSize();


}
void KlipOQueryPreferences::setTopRanking(int n)
{
	topRankingLabel->setText(QString::number(n));
	newConfig->setTop(n);
}
void KlipOQueryPreferences::createGeneralTab()
{
	sliderBox = new QGroupBox(1,Qt::Horizontal,i18n("Number of top ranked services"),general);
	topSlider = new QSlider(0,10,1,newConfig->getTop(),Qt::Horizontal,sliderBox);
	topSlider->setTickmarks(QSlider::Below);
	topRankingLabel = new QLabel(QString::number(newConfig->getTop()),sliderBox);
	
	browserBox = new QGroupBox(1,Qt::Horizontal,i18n("Browser"),general);
	browserLabel = new QLabel(i18n("Alternativ Browser (leave empty to use default)")+":",browserBox);
	browserField = new QLineEdit(newConfig->getBrowser(),browserBox);
	
}
