/***************************************************************************
 *   Copyright (C) 2004 by Michael Vonrden                                *
 *   mail@michael-vonrueden.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KLIPOQUERYPREFERENCES_H
#define KLIPOQUERYPREFERENCES_H
#include <qwidget.h> 
#include <klistview.h> 
#include <qvbox.h> 
#include <qlineedit.h> 
#include <qlabel.h> 
#include <qcheckbox.h>
#include <qslider.h> 
#include <qgroupbox.h> 
 
#include "klipoqueryconfig.h"
#include "klipoquery.h"

/**
@author Michael Vonrden
*/
class KlipOQueryPreferences: public QWidget
{

Q_OBJECT

public:
/**
constructs a new Preferences Dialog
@config the current config for the wbeklip applet
*/
    KlipOQueryPreferences(KlipOQueryConfig *config,  QWidget *parent = 0, const char *name = "0");

 /**
deconstructs Preferences Dialog
*/
    ~KlipOQueryPreferences();
    
    
    public slots:
 /**
 *	invokes when a item is executed
 **/
 void listItemExecuted(QListViewItem*);
 
 /**
 * changes the name of service in the listview
 * and calls updateService()
 * operates on activeListViewItem
 **/
 void changeServiceName(const QString &text);
  /**
 * changes the description of service in the listview
 * and calls updateService()
 * operates on activeListViewItem
 **/
 void changeServiceDescription(const QString &text);
 
  /**
 * changes the url of service in the listview
 * and calls updateService()
 * operates on activeListViewItem
 **/
 
 void changeServiceURL(const QString &text);

  /**
 * set the activation flag to  a service
 *  operates on activeListViewItem
 **/
 
 void activateService();

 /**
 * handles the context clicks within the Listview
 **/
 void handleContextMenu(KListView *list,  QListViewItem *item, const QPoint &point);
 
 /**
*	sets the new top ranking value
**/
 void setTopRanking(int n);
 
  /**
*	sets the new top ranking value
**/
 void changeBrowser(const QString &browser);
 
 /**
*	replaces the new Config with the old one
**/
  void  resetConfig();
	
private:

	
/**
*build the listview for the services
*/
	void	createListView();

/**
*builds the general tab
**/
	void createGeneralTab();
	
		
/**
*build the editable field for the services
*/
	void	createEditArea();
	
/** 
* enables/diables the Edit Area
**/
	void enableEditArea(bool);

/**
* writes the changes for a service to the config
* operates on activeListViewItem
*/
	
	void updateService();
	
/**
*	indicates wether its a service group or not
* 	operates on activeListViewItem
**/
	bool isServiceGroup();

private:



/**
* the config for the klipoquery
**/
KlipOQueryConfig  *newConfig;

/**
* the current active ListItem
**/

QListViewItem *activeListViewItem;
/**
* boxlayouts for the tabs
**/
QVBox *services, *general;

//-------------  Listview
/**
* the listview for the services
**/
KListView *preferences;



//------------------ Items for the Service Change Area ------------------------------
/**
* textfields for the change Area of services
**/
QLineEdit *nameField, *descriptionField, *urlField;

/**
* labels for the change Area of services
**/
QLabel *nameLabel,  *descriptionLabel, *urlLabel, *activateLabel;

/**
* checkbox for the change Area of services
**/
QCheckBox *activateCheckBox;

//------------------ Items for the general tab

/** 
* Slider for the amount of top services
**/

QSlider *topSlider;

/**
* the groupboxes
**/

QGroupBox *sliderBox, *browserBox;

/**  the labels  for the general tab
*
**/
QLabel *topRankingLabel;
/**
* the default browser
**/
QLineEdit *browserField;
/**
* the label for the default browser
**/
QLabel *browserLabel;
};

#endif
