import random
from pykludge3d import *

# not 100% correct, as it wraps around in Y, but good enough
def getVertHeight( verts, index, arrayLen ):
	if index < 0 or index >= arrayLen:
		return 0.0
	return verts[index][2]

def generateTerrain( originX, originY, width, depth, maxHeight, numVertsWide, numVertsDeep ):
	'''creates bumpy terrain
	origin X,Y specify where the southwest corner of the terrain should go
	width and depth specify how big the terrain should be
	maxHeight determines the upper bound for the random height values
	numVerts Wide,Deep specify how many verts should be used to form the terrain'''
	verts = []
	currX = originX
	currY = originY
	incrW = width / numVertsWide
	incrD = depth / numVertsDeep
	arrayLen = numVertsWide * numVertsDeep

	# populate 'verts', using random values for the vertex Z values
	for i in range(numVertsWide):
		currX += incrW
		currY = originY
		for j in range(numVertsDeep):
			currY += incrD
			verts.append( [ currX, currY, random.uniform( 0.0, maxHeight ) ] )
	
	# smooth the heightmap
	newVerts = verts[:]
	for i in range(arrayLen):
		avgHeight = getVertHeight( verts, i, arrayLen )
		# to the -y
		avgHeight += getVertHeight( verts, i - 1, arrayLen )
		# to the +y
		avgHeight += getVertHeight( verts, i + 1, arrayLen )
		# to the -x
		avgHeight += getVertHeight( verts, i - numVertsDeep, arrayLen )
		# to the +x
		avgHeight += getVertHeight( verts, i + numVertsDeep, arrayLen )
		avgHeight /= 5.0
		newVerts[i][2] = avgHeight
		vert_insert( newVerts[i][0], newVerts[i][1], newVerts[i][2] )

	# connect verts together with quads
	for i in range(numVertsDeep, arrayLen):
		if (i+1) % numVertsDeep != 0:
			poly_insert_quad( 
				newVerts[i][0],					newVerts[i][1],					newVerts[i][2], 
				newVerts[i+1][0],				newVerts[i+1][1],				newVerts[i+1][2], 
				newVerts[i-numVertsDeep+1][0],	newVerts[i-numVertsDeep+1][1],	newVerts[i-numVertsDeep+1][2], 
				newVerts[i-numVertsDeep][0],	newVerts[i-numVertsDeep][1],	newVerts[i-numVertsDeep][2] )
		
# end of generateTerrain

register_function( __name__, generateTerrain )
