/* 
 * File:         background.c
 * 
 * Description:  dialog for loading some background images
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "background.h"
#include "texture.h"
#include "globals.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif


// fixme - make an array
Texture *background_img_xy = NULL;
Texture *background_img_yz = NULL;
Texture *background_img_xz = NULL;

float background_box_size[3];

GtkWidget *background_box_size_entry[3];

GtkWidget *background_entry_xy = NULL;
GtkWidget *background_entry_yz = NULL;
GtkWidget *background_entry_xz = NULL;


void background_choose_file_ok( GtkWidget *w, gpointer data ) ;
void background_choose_file( GtkWidget *w, gpointer data ) ;
void background_set_images_ok( GtkWidget *widget, gpointer data ) ;


void background_set_images( GtkWidget *widget, gpointer data ) {

    GtkWidget *dialog, *vbox, *hbox;
    GtkWidget *entry, *button, *label;
    
    
    dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(dialog), "Load Background Images");
    
    vbox = gtk_vbox_new( FALSE, 0 );
    gtk_container_add(GTK_CONTAINER(dialog), vbox);
    

    hbox = gtk_hbox_new( FALSE, 0 );
    
    label = gtk_label_new( "XY plane" );
    gtk_box_pack_start( GTK_BOX( hbox ), label, TRUE, FALSE, 0 );
    
    entry = gtk_entry_new();
    background_entry_xy = entry;
    gtk_box_pack_start( GTK_BOX( hbox ), entry, TRUE, FALSE, 0 );
    
    button = gtk_button_new_with_label( "Browse..." );
    g_signal_connect( G_OBJECT( button ), "clicked",
                        G_CALLBACK( background_choose_file ), entry );
    gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, FALSE, 0 );
    
    gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, FALSE, 0 );
    

    hbox = gtk_hbox_new( FALSE, 0 );
    
    label = gtk_label_new( "YZ plane" );
    gtk_box_pack_start( GTK_BOX( hbox ), label, TRUE, FALSE, 0 );
    
    entry = gtk_entry_new();
    background_entry_yz = entry;
    gtk_box_pack_start( GTK_BOX( hbox ), entry, TRUE, FALSE, 0 );
    
    button = gtk_button_new_with_label( "Browse..." );
    g_signal_connect( G_OBJECT( button ), "clicked",
                        G_CALLBACK( background_choose_file ), entry );
    gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, FALSE, 0 );
    
    gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, FALSE, 0 );
    
    

    hbox = gtk_hbox_new( FALSE, 0 );
    
    label = gtk_label_new( "XZ plane" );
    gtk_box_pack_start( GTK_BOX( hbox ), label, TRUE, FALSE, 0 );
    
    entry = gtk_entry_new();
    background_entry_xz = entry;
    gtk_box_pack_start( GTK_BOX( hbox ), entry, TRUE, FALSE, 0 );
    
    button = gtk_button_new_with_label( "Browse..." );
    g_signal_connect( G_OBJECT( button ), "clicked",
                        G_CALLBACK( background_choose_file ), entry );
    gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, FALSE, 0 );
    
    gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, FALSE, 0 );
    
    

    hbox = gtk_hbox_new( FALSE, 0 );
    
    label = gtk_label_new( "X size" );
    gtk_box_pack_start( GTK_BOX( hbox ), label, TRUE, FALSE, 0 );
    entry = gtk_entry_new();
    background_box_size_entry[0] = entry;
    gtk_entry_set_text( GTK_ENTRY( entry ), "1.0" );
    gtk_box_pack_start( GTK_BOX( hbox ), entry, TRUE, FALSE, 0 );
    
    
    label = gtk_label_new( "Y size" );
    gtk_box_pack_start( GTK_BOX( hbox ), label, TRUE, FALSE, 0 );
    entry = gtk_entry_new();
    background_box_size_entry[1] = entry;
    gtk_entry_set_text( GTK_ENTRY( entry ), "1.0" );
    gtk_box_pack_start( GTK_BOX( hbox ), entry, TRUE, FALSE, 0 );
    
    
    label = gtk_label_new( "Z size" );
    gtk_box_pack_start( GTK_BOX( hbox ), label, TRUE, FALSE, 0 );
    entry = gtk_entry_new();
    background_box_size_entry[2] = entry;
    gtk_entry_set_text( GTK_ENTRY( entry ), "1.0" );
    gtk_box_pack_start( GTK_BOX( hbox ), entry, TRUE, FALSE, 0 );
    
    gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, FALSE, 0 );
    
    

    hbox = gtk_hbox_new( FALSE, 0 );
    
    button = gtk_button_new_with_label( "OK" );
    g_signal_connect( G_OBJECT( button ), "clicked",
                        G_CALLBACK( background_set_images_ok ), NULL );
	g_signal_connect_swapped( G_OBJECT( button ), "clicked",
						G_CALLBACK( gtk_widget_destroy ), dialog );
    gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, FALSE, 0 );
    
    button = gtk_button_new_with_label( "Cancel" );
	g_signal_connect_swapped( G_OBJECT( button ), "clicked",
						G_CALLBACK( gtk_widget_destroy ), dialog );
    gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, FALSE, 0 );
    
    gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, FALSE, 0 );
    
    gtk_widget_show_all( vbox );
    
    gtk_widget_show( dialog );
}

void background_choose_file_ok( GtkWidget *w, gpointer data ) {

    const gchar *p;
    GtkWidget *chf;

    chf = gtk_widget_get_toplevel(w);

    p = gtk_file_selection_get_filename(GTK_FILE_SELECTION(chf));

    gtk_entry_set_text(GTK_ENTRY(data), p);

    
}


void background_choose_file( GtkWidget *w, gpointer data ) {

    GtkWidget *chf = NULL;

        chf = gtk_file_selection_new( "Load an Image" );
        g_signal_connect( G_OBJECT(chf), "destroy",
            G_CALLBACK( gtk_widget_destroyed ), &chf);

        g_signal_connect( G_OBJECT(GTK_FILE_SELECTION(chf)->ok_button),
            "clicked", G_CALLBACK( background_choose_file_ok ), data);

		g_signal_connect_swapped( 
			G_OBJECT(GTK_FILE_SELECTION(chf)->ok_button), 
			"clicked", G_CALLBACK( gtk_widget_destroy ), chf );

		g_signal_connect_swapped( 
			G_OBJECT(GTK_FILE_SELECTION(chf)->cancel_button), 
			"clicked", G_CALLBACK( gtk_widget_destroy ), chf );

    gtk_widget_show( chf );
    if( GTK_WIDGET_REALIZED( chf ) )
        gdk_window_raise(chf->window);
}




void background_set_images_ok( GtkWidget *widget, gpointer data ) {
    
    int i;
    
    tex_delete( background_img_xy );
    tex_delete( background_img_yz );
    tex_delete( background_img_xz );
    
    background_img_xy = 
		tex_load( gtk_entry_get_text( GTK_ENTRY( background_entry_xy ) ), 
					TEXTURE_FORMAT_UNKNOWN, NULL );
    if( background_img_xy == NULL ) {
		/* oh well... */
    }


    background_img_yz = 
		tex_load( gtk_entry_get_text( GTK_ENTRY( background_entry_yz ) ), 
					TEXTURE_FORMAT_UNKNOWN, NULL );
    if( background_img_yz == NULL ) {
		/* oh well... */
    }


    background_img_xz = 
		tex_load( gtk_entry_get_text( GTK_ENTRY( background_entry_xz ) ), 
					TEXTURE_FORMAT_UNKNOWN, NULL );
    if( background_img_xz == NULL ) {
		/* oh well... */
    }


    for( i = 0; i < 3; i++ ) {
        const gchar *temp;
        
        temp = gtk_entry_get_text( GTK_ENTRY( background_box_size_entry[i] ) );
        background_box_size[i] = strtod( temp, (char **)NULL );
    }

}




