/* 
 * File:         bottombar.c
 * 
 * Description:  funcs for creating the bottom bar
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <gtk/gtk.h>


#include "bottombar.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif


/* DEFINES ****************************************************************/

#define MAX_STRING_LENGTH 256


/* FILE-SCOPE VARS ********************************************************/

GtkWidget *bb_coords = NULL;
GtkStatusbar * statusbar;
guint waitTime = 0;


/* PROTOTYPES *************************************************************/

gboolean bb_pop_message( gpointer data ) ;


/* FUNCS ******************************************************************/

gboolean bb_pop_message( gpointer data ) {
	
	gtk_statusbar_pop( statusbar,
						gtk_statusbar_get_context_id( statusbar, "default" ) );
	waitTime -= (guint)(data);
	return FALSE; /* important */
}


void bb_push_message( float durationf, char * message ) {
	guint messageId;
	guint duration;

	duration = (guint)(durationf * 1000.);
	waitTime += duration;
	
	messageId = 
	gtk_statusbar_push( statusbar,
						gtk_statusbar_get_context_id( statusbar, "default" ),
						message );
	gtk_timeout_add( waitTime, 
					 bb_pop_message, (gpointer)duration );
}


void bb_push_message_f( float duration, char *msgfmt, ... ) {
	char message[ MAX_STRING_LENGTH ];
	va_list ap;

	va_start( ap, msgfmt );
	vsnprintf( message, MAX_STRING_LENGTH - 1, msgfmt, ap );
/*	vsprintf ( message, msgfmt, ap );*/
	va_end( ap );

	bb_push_message( duration, message );
}


GtkWidget *create_bottombar( void ) {
	GtkWidget *frame;

	statusbar = (GtkStatusbar*)gtk_statusbar_new();
	gtk_widget_show( GTK_WIDGET( statusbar ) );
	
	/* NOTE - status bars are actually just glorified hboxes.  This means 
	we can add widgets to them, just like any other hbox.  (I don't know why 
	the gtk people went to the trouble.  It would be easier and more 
	flexible to have a label-style status bar rather than a complete 
	hbox-enclosed-label-style status bar.) */

	frame = gtk_frame_new( NULL );
	gtk_frame_set_shadow_type( GTK_FRAME( frame ), GTK_SHADOW_IN );
	bb_coords = gtk_label_new(NULL);
	gtk_label_set_justify( GTK_LABEL( bb_coords ), GTK_JUSTIFY_LEFT );
	gtk_label_set_text(GTK_LABEL( bb_coords ), "[0, 0, 0]");
	gtk_container_add( GTK_CONTAINER( frame ), bb_coords );
	gtk_box_pack_start(GTK_BOX( statusbar ), frame, TRUE, TRUE, 0);
	
	/* relocate coord label to beginning of status bar */
	gtk_box_reorder_child( GTK_BOX( statusbar ), frame, 0 );
	
	gtk_widget_show( bb_coords );
	gtk_widget_show( frame );

	bb_push_message( 2.5, "Welcome to kludge3d" );
	
	return GTK_WIDGET( statusbar );
}



void bb_update_coords( gchar *coords) {

    gtk_label_set_text(GTK_LABEL( bb_coords ), coords);

}
