/* 
 * File:         clipboard.c
 * 
 * Description:  funcs for managing clipboard (the entries in the "Edit" menu)
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <glib.h>
#include <string.h>

#include "clipboard.h"
#include "vertex.h"
#include "polygon.h"
#include "model.h"
#include "vector.h"
#include "undo.h"
#include "selection.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif


GSList *clipboard_vertices = NULL;

void clipboard_vertices_copy( void ) {
	
	GSList* vl;
	Vertex * v = NULL;
	
	for( vl = clipboard_vertices; vl; vl = vl->next ) {
		vertex_delete( (Vertex*)vl->data );
	}
	g_slist_free( clipboard_vertices );
	clipboard_vertices = NULL;
	
	for( vl = the_model->selected_verts; vl; vl = vl->next ) {
		v = vertex_dup( (Vertex*)vl->data );
		clipboard_vertices = g_slist_append( clipboard_vertices, (gpointer)v );
	}
	
}

void clipboard_vertices_cut( void ) {

	clipboard_vertices_copy();
	clipboard_vertices_kill();
}

void clipboard_vertices_paste( void ) {

	GSList *vl, *new_verts = NULL;
	Vertex * v = NULL;
	
	if( the_model->current_mesh == NULL )
		return;

	sel_vert_unselect_all( the_model );
	
//FIXME - this may screw up the undo stuff (if it ever actually handles stuff like vertex adds and deletes)
	for( vl = clipboard_vertices; vl; vl = vl->next ) {
		Vertex* source = (Vertex*)vl->data;
		v = vertex_dup( source );
		
		model_vertex_add( the_model, v );
		mesh_vertex_add( the_model->current_mesh, v );
		new_verts = g_slist_append( new_verts, v );
	}
	
	sel_vert_select_list( new_verts );
	g_slist_free( new_verts );
}


void clipboard_vertices_kill( void ) {

	GSList *l;
	GSList *svl = g_slist_copy( the_model->selected_verts );

	sel_vert_unselect_all( the_model );

	for( l = svl; l; l = l->next ) {
		model_vertex_remove( the_model, (Vertex*)(l->data) );
	}

	g_slist_free( svl );
}


void clipboard_polys_kill( void ) {

	GSList *l;
	GSList *spl = g_slist_copy( the_model->selected_polys );

	sel_poly_unselect_all( the_model );
	
	for( l = spl; l; l = l->next ) {
		model_polygon_remove( the_model, (Poly*)(l->data) );
	}

	g_slist_free( spl );
}


