/*
 * File:				 documents.c
 * 
 * Description:	handles the list of models
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */


#include "globals.h"
#include "documents.h"
#include "undo.h"


#ifdef MEMWATCH
#include "memwatch.h"
#endif


/* GLOBALS ****************************************************************/

GSList *models = NULL;


/* FUNCS ******************************************************************/

void docs_switch_model( Model *m ) {
	if( m == NULL ) return;

	the_model = m;
	
	g_signal_emit_by_name( notificationObj, 
		"switched-model", m );
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
	g_signal_emit_by_name( notificationObj, 
		"notify::model-structure-changed", NULL );
	g_signal_emit_by_name( notificationObj, 
		"notify::model-texturelist-changed", NULL );

}

void docs_add_model( Model *m ) {
	if( m == NULL ) return;
	
	models = g_slist_append( models, m );
    undo_enable( m );
	
	g_signal_emit_by_name( notificationObj, 
		"added-model", m );
}


void docs_remove_model( Model *m ) {
	if( m == NULL ) return;
	
	models = g_slist_remove( models, m );

	g_signal_emit_by_name( notificationObj, 
		"removed-model", m );

	action_clear_stack( m );
	model_delete( m );
}


void docs_cleanup( void ) {
	GSList *l;
	
	for( l = models; l; l = l->next ) {
		action_clear_stack( (Model*)l->data );
		model_delete( (Model*)l->data );
	}
	
	g_slist_free( models );
	models = NULL;
	
	the_model = NULL;
}

