/* 
 * File:         file_utils.h
 * 
 * Description:  header for file_utils.c
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 
#ifndef FILE_UTILS_H
#define FILE_UTILS_H

#include <stdio.h>
#include <glib.h>

struct fu_file {
  int fd;
  FILE *fp;
  GHashTable *len_ht;
};

struct fu_file *fu_open(const gchar *name, gint create);
void fu_close(struct fu_file *file);
guint fu_file_size(struct fu_file *file);
guchar *fu_map_block(struct fu_file *file, guint start, guint len);
void fu_unmap_block(struct fu_file *file, guchar *block);
void fu_write_block(struct fu_file *file, guchar *block, guint len);
void fu_truncate(struct fu_file *file, guint size);
void fu_seek(struct fu_file *file, gint pos);
gint fu_gets(struct fu_file *file, gchar *buf, guint len);
gint fu_puts(struct fu_file *file, gchar *buf);
gint fu_printf(struct fu_file *file, gchar *fmt, ...);


#endif
