/* 
 * File:         fmt_generic.c
 * 
 * Description:  Generic file format handler code
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 
/*
 * This file is from:
 *    - ME3D 3-D Modeler Program   by Sam Revitch
 *
 */

/* Generic file format handler code */
/* Tailor to new formats as necessary */
/* NOTE: This file is a template and isn't compiled in */


#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>

#include "transform.h"
#include "globals.h"
#include "mesh.h"
#include "model.h"
#include "polygon.h"
#include "vertex.h"
#include "texture.h"
#include "bottombar.h"

#include "model_load_save.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif



gint generic_load_doc(struct fu_file *file, Model *doc);
gint generic_save_doc(struct fu_file *file, Model *doc);
void generic_destroy_priv_data(Model *doc);


struct doc_file_fmt fmt_generic = {
  "Generic Format (gen)",
  "gen",
  generic_load_doc,
  generic_save_doc,
  generic_destroy_priv_data	/* <-- replace with NULL if not used */
};
/* To register: add a reference to the above structure in model_load_save.c */


/* Load the document from fu_file and set the root member of doc */
gint generic_load_doc(struct fu_file *file, Model *doc)
{

  /* You can use fu_map_block(struct fu_file *file, guint offset, guint len)
     to memory-map a block for reading */
  return True;
}


/* Save the document to fu_file */
gint generic_save_doc(struct fu_file *file, Model *doc)
{

  fu_truncate(file, 0);		/* it's a good idea to truncate first */
                                /* unless you have a more complex format */

  /* You can use fu_write_block(fu_file *file, guchar *buf, guint len)
     to write a block to the file at the last offset */
  return True;
}


/* Destroy the contents of doc->fmt_data */
void generic_destroy_priv_data(Model *doc)
{
}
