/* 
 * File:         frame.c
 * 
 * Description:  manages the 4 view panes
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 

#include "frame.h"
#include "view.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif

/* FILE SCOPE VARS ****************************************************/

GtkWidget *table_child[ 4 ];
GtkWidget *table;


/* PROTOTYPES *********************************************************/

gint expand_cb( GtkWidget *widget, gpointer data ) ;
GtkWidget *frame_new( GtkWidget * w, int projection_type ) ;


/* FUNCS **************************************************************/

gint expand_cb( GtkWidget *widget, gpointer data ) {
    int c;
    static int ms = 1;

    if ( ms ) {
        for ( c = 0; c < 4; c++ )
            if ( table_child[ c ] != ( GtkWidget * ) data ) gtk_widget_hide( table_child[ c ] );
        gtk_table_set_homogeneous( GTK_TABLE( table ), 0 );
    } else {
        for ( c = 0; c < 4; c++ )
            if ( table_child[ c ] != ( GtkWidget * ) data ) gtk_widget_show( table_child[ c ] );
        gtk_table_set_homogeneous( GTK_TABLE( table ), 1 );
    }

    ms = ms ? 0 : 1;

    return FALSE;
}



GtkWidget *frame_new( GtkWidget * w, int projection_type ) {
	GtkWidget *expand_btn, *vbox, *hbox;
	GtkWidget *flip_btn = NULL;

	vbox = gtk_vbox_new( FALSE, 0 );
	hbox = gtk_hbox_new( FALSE, 0 );
	
	switch( projection_type ) {
		case VIEW_XY:
			expand_btn = gtk_button_new_with_label( "XY - Top" );
			flip_btn = gtk_button_new_with_label( "Flip" );
			break;
		case VIEW_YZ:
			expand_btn = gtk_button_new_with_label( "YZ - Side" );
			flip_btn = gtk_button_new_with_label( "Flip" );
			break;
		case VIEW_XZ:
			expand_btn = gtk_button_new_with_label( "XZ - Side" );
			flip_btn = gtk_button_new_with_label( "Flip" );
			break;
		case VIEW_3D:
			expand_btn = gtk_button_new_with_label( "3D Preview" );
			break;
		default:
			expand_btn = gtk_button_new_with_label( "Something Bad" );
			break;
	}

	if( flip_btn != NULL ) {
		gtk_box_pack_start( GTK_BOX( hbox ), flip_btn, FALSE, FALSE, 0 );
		gtk_widget_show( flip_btn );
		g_signal_connect( G_OBJECT( flip_btn ), "clicked",
							G_CALLBACK( view_flip_cb ), 
							( gpointer ) projection_type );
	}
	gtk_box_pack_start( GTK_BOX( hbox ), expand_btn, TRUE, TRUE, 0 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 0 );
	gtk_box_pack_start( GTK_BOX( vbox ), w, TRUE, TRUE, 0 );
	
	gtk_widget_show( vbox );
	gtk_widget_show( hbox );
	gtk_widget_show( expand_btn );

	g_signal_connect( G_OBJECT( expand_btn ), "clicked",
						G_CALLBACK( expand_cb ), ( gpointer ) vbox );

	return vbox;
}


GtkWidget * create_frames( ) {
    GtkWidget * glp;

    table = gtk_table_new( 2, 2, 1 );
    gtk_widget_show( table );


    glp = frame_new( create_view( VIEW_XY ), VIEW_XY );
    gtk_table_attach_defaults( GTK_TABLE( table ), glp, 0, 1, 0, 1 );
    table_child[ VIEW_XY ] = glp;


    glp = frame_new( create_view( VIEW_YZ ), VIEW_YZ );
    gtk_table_attach_defaults( GTK_TABLE( table ), glp, 1, 2, 0, 1 );
    table_child[ VIEW_YZ ] = glp;


    glp = frame_new( create_view( VIEW_XZ ), VIEW_XZ );
    gtk_table_attach_defaults( GTK_TABLE( table ), glp, 0, 1, 1, 2 );
    table_child[ VIEW_XZ ] = glp;


    glp = frame_new( create_view( VIEW_3D ), VIEW_3D );
    gtk_table_attach_defaults( GTK_TABLE( table ), glp, 1, 2, 1, 2 );
    table_child[ VIEW_3D ] = glp;


    return table;
}




