/* 
 * File:         geo.h
 * 
 * Description:  defines Vertex, Tri, and TexCoord structs
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 

#ifndef GEO_H
#define GEO_H

#include <stdlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <glib.h>

#include "transform.h"
#include "texture.h"

/* forward decl of Model, needed in order to avoid circular dep */
typedef struct _Model Model;

typedef enum {
	PRIM_TYPE_UNKNOWN,
	PRIM_TYPE_VERTEX,
	PRIM_TYPE_POLY,
	
	PRIM_TYPE_MAX
} PrimitiveType;

typedef struct _Primitive Primitive;
typedef struct _Vertex Vertex;
typedef struct _Poly Poly;
typedef struct _TexCoord TexCoord;
typedef struct _Mesh Mesh;


struct _Primitive {
	int ref_count;
	void (* delete_func)( Primitive * );
	char type;
};

struct _Vertex {
	Primitive primitive;

    GLfloat v[ 3 ];
    char selected;
    char hidden;
    
	Poly **polys;
	int num_polys;
	
	Model *model;
};

struct _Poly {
	Primitive primitive;

    Vertex **verts;
    TexCoord **tc;
    GLfloat normal[3];
    int num_verts;
    char selected;
    char hidden;

    Mesh *mesh;
};

struct _TexCoord {
    // i guess they should actually be called "u" and "v",
    // or "s" and "t"... whatever.
    double x, y;
};

struct _Mesh {
    GSList *vertices;
    GSList *polygons;
    Texture *texture;
    float texrep_x, texrep_y;

    char* name;

    Trans *trans;     /* rotation only, translation is handled by next elem */
	float loc[3];

//    GSList *lines;
    GLuint list, dirty;
	char hidden;
	
	Model *model;
};



#endif
