/* 
 * File:         globals.h
 * 
 * Description:  globals.  ugh.
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 
#ifndef GLOBALS_H
#define GLOBALS_H

#include <glib-object.h>


/*
notify::model-structure-changed
	emitted when the current model's structure has been changed; this includes 
	events such as: a new, empty group being added; an existing group being 
	moved within the document tree; etc
notify::model-appearance-changed
	emitted when the current model's appearance has been altered; this includes 
	events such as: vertex moved; vertex/poly added; texture coordinate 
	changed; etc
notify::model-texturelist-changed
	emitted when the current model's texture list has been altered
notify::added-model
	emitted when a new model has been loaded (one which ought to appear in the 
	Documents menu)
notify::removed-model
	emitted when a model has been removed from the Documents menu
notify::exit
	emitted when the program is about to exit; this gives the various 
	subsystems a chance to free any allocated memory, etc
*/
extern gpointer notificationObj;

#endif
