/* 
 * File:         glpreview.h
 * 
 * Description:  header for glp.c
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 
#ifndef GL_PREVIEW_H
#define GL_PREVIEW_H

#include <gtk/gtk.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <gtk/gtkgl.h>

#include "geo.h"
#include "view.h"


//GtkWidget *make_new_gl_preview( int type );

void glp_glconfigure( model_view *view );
void glp_glviewport( model_view *view );


void glp_render( model_view *view );
void glp_expose( model_view * view );

void glp_draw_selection_box( model_view* view, float startx, float starty,
                             float endx, float endy );


int glp_unproject( model_view *view, 
                   int winx, int winy, 
                   GLfloat* objx, GLfloat* objy, GLfloat* objz );
Vertex *glp_test_click_vertex( model_view *view, GLfloat *z, 
                                guint x, guint y );
GSList *glp_test_click_vertices( model_view *view, GLfloat *z, 
                                guint x, guint y, 
                                guint width, guint height );
Poly *glp_test_click_polygon( model_view *view, GLfloat *z,
                             guint xc, guint yc ) ;
GSList *glp_test_click_polygons( model_view *view, GLfloat *z,
                                guint x, guint y,
                                guint width, guint height ) ;

void glp_rebuild_display_lists( model_view *view );
void glp_set_triangleorder( model_view *view ) ;

#endif
