#include <glib.h>
#include <glib-object.h>
#include <stdio.h>

gboolean shockTheMonkey( gpointer data ) {
	printf( "Shock the monkey it hurts, MONKEY!\n" );
	return TRUE;
}

gboolean badMonkey( gpointer data ) {
	printf( "MONKEY HAS BEEN BAD!\n" );
	return FALSE;
}

gboolean goodMonkey( gpointer data ) {
	printf( "MONKEY HAS BEEN GOOD!\n" );
	return FALSE;
}

int main( void ) {
	char buf[128];
	gpointer fooObj;
	GParamSpec ** objectProperties;
	int numProperties;
	
	guint * signalIds;
	guint numSignalIds;
	guint i;

	g_type_init();

	printf( "The name for G_TYPE_INT is %s \n", g_type_name( G_TYPE_INT ) );
	
	fooObj = 
		g_object_new( G_TYPE_OBJECT, NULL );
	
	objectProperties = g_object_class_list_properties( 
		G_OBJECT_GET_CLASS( fooObj ), &numProperties );
	
	printf( "GObject has %i properties \n", numProperties );

	signalIds = g_signal_list_ids( G_OBJECT_TYPE( fooObj ), &numSignalIds );
	
	printf( "GObject has %i signals \n", numSignalIds );
	for( i = 0; i < numSignalIds; i++ ) {
		GSignalQuery q;
		int j;
		printf( "looking up signal %i\n", signalIds[i] );
		g_signal_query( signalIds[i], &q );
		printf( "signal %i has name %s\n", signalIds[i], q.signal_name );
		printf( "signal %i has %i parameters\n", signalIds[i], q.n_params );
		
		for( j = 0; j < q.n_params; j++ ) {
			printf( "\tparam %i is %s \n", j, g_type_name( q.param_types[j] ) );
		}
	}


	g_signal_connect( 
		fooObj, "notify", G_CALLBACK(shockTheMonkey), NULL );
	
	g_signal_connect( 
		fooObj, "notify::badmonkey", G_CALLBACK(badMonkey), NULL );
	
	g_signal_connect( 
		fooObj, "notify::goodmonkey", G_CALLBACK(goodMonkey), NULL );
	
	while( fgets( buf, 127, stdin ) ) {
		g_signal_emit_by_name( fooObj, "notify", NULL );
		g_signal_emit_by_name( fooObj, "notify::badmonkey", NULL );
		g_signal_emit_by_name( fooObj, "notify::goodmonkey", NULL );
	}
	
	return 0;
}
