/* 
 * File:         group.c
 * 
 * Description:  handles group-related stuff
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>

#include "group.h"
#include "transform.h"
#include "globals.h"
#include "mesh.h"
#include "polygon.h"
#include "vertex.h"
#include "primitive.h"
#include "undo.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif


gboolean group_delete_tree( GNode *node, gpointer data ) ;
GNode *group_duplicate_tree( GNode *node ) ;

// GROUP STUFF /////////////////////////////////////////////////////////////


GNode *group_new( Model *model ) {
    GNode * node;
    Mesh * m = mesh_new( model );

    node = g_node_new( m );
    
    return node;
}

gboolean group_delete_tree( GNode *node, gpointer data ) {
    // recurse through tree
    
    Mesh* m = (Mesh*)node->data;

    mesh_delete( m );
    node->data = NULL;
    
    return FALSE;  /* we want it to continue... */
}


void group_delete( GNode *node ) {

    if( node != NULL ) {
        g_node_traverse( node, G_POST_ORDER, G_TRAVERSE_ALL, -1,
                         group_delete_tree, (gpointer)NULL );
        g_node_destroy( node );
    }


}


GNode *group_duplicate_tree( GNode *node ) {
    // recurse through tree
    
    GNode *copy = NULL;
    GNode *children;
    Mesh* m = (Mesh*)node->data;

    m = mesh_dup( m );
    copy = g_node_new( m );
    
    for( children = node->children; children; children = children->next ) {
        g_node_append( copy, group_duplicate_tree( children ) );
    }
    
    return copy;
}


void group_duplicate( GNode *root ) {

    /* performs a deep copy of root and places the copy underneath root */
    
    GNode *copy;
    
    if( root == NULL ) return;

    copy = group_duplicate_tree( root );
    if( copy != NULL )
        g_node_prepend( root, copy ); /* make copy the first child of root */

}


int group_reparent( Model *model, GNode *node, GNode *new_parent ) {

    g_return_val_if_fail( node != NULL, FALSE );
    g_return_val_if_fail( new_parent != NULL, FALSE );
/*    g_return_val_if_fail( node->parent != NULL, FALSE );*/
    g_return_val_if_fail( node != new_parent, FALSE );
    
    g_node_unlink( node );
    g_node_append( new_parent, node );
    
	action_do( model, ACTION_UNKNOWN, NULL, NULL, NULL, NULL, NULL, NULL );
	return TRUE;
}


/* Takes a node in the tree and makes it into a leaf...
   merges the meshes of n's children into n.
*/
void group_merge( Model *model, GNode * n ) {
    
    Mesh *mP = NULL;
    Mesh *mC = NULL;
    GNode *child = NULL;
    
    if( n == NULL )
        return;
    
    mP = (Mesh*)(n->data);
    
    for( child = n->children; child != NULL; child = child->next ) {
        group_merge( model, child );
        mC = (Mesh*)child->data;
        mesh_merge( mP, mC );
        
        child->data = NULL;
    }
    
    /* kill the children */
    child = n->children; 
    while( child != NULL ) {
        g_node_destroy( child );
        child = n->children;
    }
    n->children = NULL;

	action_do( model, ACTION_UNKNOWN, NULL, NULL, NULL, NULL, NULL, NULL );
}


void group_new_group_from_polys( Model *model, GNode *parent, GSList *polys ) {
    Mesh *m;
    Poly *p;
	GSList *l;
    
    if( parent == NULL || polys == NULL || model == NULL )
        return;

    m = mesh_new( model );

    for( l = polys; l; l = l->next ) {
		p = (Poly*)l->data;

		mesh_polygon_reparent( p, m );
    }

    g_node_prepend( parent, g_node_new( m ) );
	action_do( model, ACTION_UNKNOWN, NULL, NULL, NULL, NULL, NULL, NULL );
}



