/*
 * File:        material.c
 * 
 * Description:	
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */

#include <string.h>

#include "material.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif


Material *material_new( void ) {
	int i;
	Material *result;
	result = (Material*)malloc( sizeof( Material ) );
	memset( result, 0, sizeof( Material ) );
	
#if 0
	result->diffuse[3] = 1.0;
	result->ambient[3] = 1.0;
	result->emission[3] = 1.0;
#endif

	/* the default material should be opaque white, with minimal 
	specular and shininess values */
	for( i = 0; i < 4; i++ ) {
		result->diffuse[i] = 1.0;
		result->ambient[i] = 1.0;
		result->emission[i] = 1.0;
	}

	result->specular[0] = 0.01;
	result->specular[1] = 0.01;
	result->specular[2] = 0.01;
	result->specular[3] = 1.0;

	result->shininess = 127.0;
	
	return result;
}


void material_copy( Material *dest, Material *src ) {
	int i;
	
	if( dest == NULL || src == NULL ) return;
	
	for( i = 0; i < 4; i++ ) {
		dest->diffuse[i] = src->diffuse[i];
		dest->ambient[i] = src->ambient[i];
		dest->emission[i] = src->emission[i];
		dest->specular[i] = src->specular[i];
	}
	
	dest->shininess = src->shininess;
}


/* Copies the contents of the Material into an array of floats.  Ignores the 
'shininess' member... you can retrieve that member directly from the Material 
struct anyway. */
void material_copy_to_array( Material *material, float array[4][4] ) {
	
	if( material == NULL || array == NULL ) return;

	array[MAT_INDEX_DIFFUSE][0] = material->diffuse[0];
	array[MAT_INDEX_DIFFUSE][1] = material->diffuse[1];
	array[MAT_INDEX_DIFFUSE][2] = material->diffuse[2];
	array[MAT_INDEX_DIFFUSE][3] = material->diffuse[3];

	array[MAT_INDEX_AMBIENT][0] = material->ambient[0];
	array[MAT_INDEX_AMBIENT][1] = material->ambient[1];
	array[MAT_INDEX_AMBIENT][2] = material->ambient[2];
	array[MAT_INDEX_AMBIENT][3] = material->ambient[3];

	array[MAT_INDEX_EMISSION][0] = material->emission[0];
	array[MAT_INDEX_EMISSION][1] = material->emission[1];
	array[MAT_INDEX_EMISSION][2] = material->emission[2];
	array[MAT_INDEX_EMISSION][3] = material->emission[3];

	array[MAT_INDEX_SPECULAR][0] = material->specular[0];
	array[MAT_INDEX_SPECULAR][1] = material->specular[1];
	array[MAT_INDEX_SPECULAR][2] = material->specular[2];
	array[MAT_INDEX_SPECULAR][3] = material->specular[3];

}

