/* 
 * File:         material.h
 * 
 * Description:  header for material.c
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */

#ifndef MATERIAL_H
#define MATERIAL_H

enum mat_index_enum {
	MAT_INDEX_DIFFUSE = 0,
	MAT_INDEX_AMBIENT,
	MAT_INDEX_EMISSION,
	MAT_INDEX_SPECULAR,
	MAT_INDEX_SHININESS,
	MAT_INDEX_NUM_INDICES
};

typedef struct _Material Material;
struct _Material {
	float ambient[4];	/* 0.0 to 1.0 for all 4 elements */
	float diffuse[4];	/* 0.0 to 1.0 for all 4 elements */
	float specular[4];	/* 0.0 to 1.0 for all 4 elements */
	float emission[4];	/* 0.0 to 1.0 for all 4 elements */
	float shininess;	/* 0.0 to 128.0 */
};


Material *material_new( void );
void material_copy( Material *dest, Material *src );
void material_copy_to_array( Material *material, float array[4][4] ) ;

#endif

