/* 
 * File:         menu.c
 * 
 * Description:  creates and manages the menu bar at the top of the main window
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 


#include "menu.h"
#include "model_load_save.h"
#include "vertex.h"
#include "view_config.h"
#include "background.h"
#include "undo.h"
#include "notebook.h"
#include "clipboard.h"
#include "selection.h"
#include "doc_man.h"
#include "documents.h"
#include "pref_man.h"
#include "log_window.h"
#include "mat_edit.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif



gint menu_close_dialog_ok( GtkWidget *widget, gpointer data ) ;
gint menu_show_close_dialog( GtkWidget *widget, gpointer data ) ;
gint menu_show_log_window( GtkWidget *widget, gpointer data ) ;
gint menu_show_prefs_dialog( GtkWidget *widget, gpointer data ) ;
void menu_show_about( GtkWidget *widget, gpointer data );
gint menu_show_mat_edit( GtkWidget *widget, gpointer data ) ;

void edit_cut_cb( GtkWidget *widget, gpointer data );
void edit_copy_cb( GtkWidget *widget, gpointer data );
void edit_paste_cb( GtkWidget *widget, gpointer data );
void edit_delete_cb( GtkWidget *widget, gpointer data ) ;
void menu_hide_verts( GtkWidget *widget, gpointer data ) ;
void menu_hide_polys( GtkWidget *widget, gpointer data ) ;
void menu_show_verts( GtkWidget *widget, gpointer data ) ;
void menu_show_polys( GtkWidget *widget, gpointer data ) ;
void menu_show_normals( GtkWidget *widget, gpointer data ) ;
void menu_undo_cb( GtkWidget *widget, gpointer data ) ;
 
static GtkItemFactoryEntry menu_items[] = {
    {"/_File", NULL, NULL, 0, "<Branch>" },
    {"/File/_New", "<control>N", G_CALLBACK( menu_new_model ), 0, NULL},
    {"/File/_Open", "<control>O", G_CALLBACK( menu_show_load_dialog ), 0, NULL},
    {"/File/_Save", "<control>S", G_CALLBACK( menu_show_save_dialog ), 0, NULL},
    {"/File/Save _As", NULL, G_CALLBACK( menu_show_saveAs_dialog ), 0, NULL},
    {"/File/sep1", NULL, NULL, 0, "<Separator>"},
    {"/File/_Close", "<control>W", G_CALLBACK( menu_show_close_dialog ), 0, NULL},
    {"/File/sep1", NULL, NULL, 0, "<Separator>"},
    {"/File/_Quit", "<control>Q", gtk_main_quit, 0, NULL},
    {"/_Edit", NULL, NULL, 0, "<Branch>"},
    {"/Edit/_Undo", "<control>Z", menu_undo_cb, 0, NULL},
    {"/Edit/sep1", NULL, NULL, 0, "<Separator>"},
    {"/Edit/Cut", "<control>X", edit_cut_cb, 0, NULL},
    {"/Edit/_Copy", "<control>C", edit_copy_cb, 0, NULL},
    {"/Edit/Paste", "<control>V", edit_paste_cb, 0, NULL},
    {"/Edit/Delete", "<control>K", edit_delete_cb, 0, NULL},
    {"/_View", NULL, NULL, 0, "<Branch>"},
    {"/View/Set Background", NULL, G_CALLBACK( background_set_images ), 0, NULL},
    {"/View/Hide Selected Verts", NULL, G_CALLBACK( menu_hide_verts ), 0, NULL},
    {"/View/Hide Selected Polys", NULL, G_CALLBACK( menu_hide_polys ), 0, NULL},
    {"/View/Show All Verts", NULL, G_CALLBACK( menu_show_verts ), 0, NULL},
    {"/View/Show All Polys", NULL, G_CALLBACK( menu_show_polys ), 0, NULL},
    {"/View/Show Normals", NULL, G_CALLBACK( menu_show_normals ), 0, "<CheckItem>"},
    {"/_Misc", NULL, NULL, 0, "<Branch>"},
    {"/Misc/Open Log Window", NULL, G_CALLBACK( menu_show_log_window ), 0, NULL},
    {"/Misc/Edit Preferences...", NULL, G_CALLBACK( menu_show_prefs_dialog ), 0, NULL},
/*    {"/Misc/XXX open mat editor XXX", NULL, G_CALLBACK( menu_show_mat_edit ), 0, NULL},*/
    {"/_Documents", NULL, NULL, 0, "<Branch>"},
    {"/_Help", NULL, NULL, 0, "<LastBranch>"},
    {"/_Help/About", NULL, menu_show_about, 0, NULL},
};


/** New model **************************************************************/

gint menu_new_model( GtkWidget *widget, gpointer data ) {
	Model *new_model;
	
	new_model = model_new();
	docs_add_model( new_model );
	docs_switch_model( new_model );

	return TRUE;
}


/** VARIOUS DIALOG CB'S ****************************************************/

gint menu_show_load_dialog( GtkWidget *widget, gpointer data ) {
    
    if( fmt_load_dialog_available() )
        fmt_show_load_dialog( "Load..." );
    
    return TRUE;
}

gint menu_show_save_dialog( GtkWidget *widget, gpointer data ) {

    if( fmt_save_dialog_available() ) {
        fmt_show_save_dialog( the_model, "Save...");
    }
    return TRUE;
}

gint menu_show_saveAs_dialog( GtkWidget *widget, gpointer data ) {
    
    if( fmt_save_dialog_available() ) {
        fmt_show_saveAs_dialog( the_model, "Save As...");
    }
    return TRUE;
}


gint menu_close_dialog_ok( GtkWidget *widget, gpointer data ) {

	/* the user has been prompted, asking if it's ok to delete
	   the current model from memory, and has clicked "OK" */

	docs_remove_model( the_model );

	if( models == NULL )
		/* create new model if there are no open models remaining */
		menu_new_model( widget, data );
	else
		/* switch to the first model */
		docs_switch_model( (Model*)models->data );
		
	return FALSE;
}

gint menu_show_close_dialog( GtkWidget *widget, gpointer data ) {
	GtkWidget * dialog, *label, *button;

/* fixme - check to see if model has been changed, ie clean vs dirty
 (requires work elsewhere)*/

	dialog = gtk_dialog_new();
	gtk_window_set_title( GTK_WINDOW( dialog ), "Close model?" );

	button = gtk_button_new_with_label( "OK" );
	gtk_box_pack_start( GTK_BOX( GTK_DIALOG( dialog ) ->action_area ), button,
						FALSE, FALSE, 5 );
	g_signal_connect( G_OBJECT( button ), "clicked",
						G_CALLBACK( menu_close_dialog_ok ), NULL );
	g_signal_connect_swapped( G_OBJECT( button ), "clicked", 
		G_CALLBACK( gtk_widget_destroy ), dialog );
	gtk_widget_show( button );

	button = gtk_button_new_with_label( "Cancel" );
	gtk_box_pack_start( GTK_BOX( GTK_DIALOG( dialog ) ->action_area ), button,
						FALSE, FALSE, 5 );
	g_signal_connect_swapped( G_OBJECT( button ), "clicked", 
		G_CALLBACK( gtk_widget_destroy ), dialog );
	gtk_widget_show( button );


	label = gtk_label_new( "  All changes will be lost.\n"
						   "  Is it OK to close this model?" );
	gtk_label_set_justify( GTK_LABEL( label ), GTK_JUSTIFY_CENTER );
	gtk_widget_show( label );
	gtk_box_pack_start( GTK_BOX( GTK_DIALOG( dialog ) ->vbox ), label,
						FALSE, FALSE, 5 );

	gtk_widget_show( dialog );

	return TRUE;
}


gint menu_show_log_window( GtkWidget *widget, gpointer data ) {
	
	show_log_window();
	
	return TRUE;
}


gint menu_show_prefs_dialog( GtkWidget *widget, gpointer data ) {

/*fixme    if( fmt_save_dialog_available() ) {*/
	
	pref_man_show();
	
	return TRUE;
}


gint menu_show_mat_edit( GtkWidget *widget, gpointer data ) {

	/*FIXME - LEAK */
	matedit_show( material_new() );
	
	return TRUE;
}


void menu_undo_cb( GtkWidget *widget, gpointer data ) {
    action_undo( the_model );
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}

void edit_cut_cb( GtkWidget *widget, gpointer data ) {
	switch( global_scope ) {
		case SCOPE_VERTEX:
			clipboard_vertices_cut();
			action_do( the_model, ACTION_MARKER, NULL, NULL, NULL, NULL, NULL, NULL );
			break;
		case SCOPE_POLYGON:
			break;
		default:
			break;
	}
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}
void edit_copy_cb( GtkWidget *widget, gpointer data ) {
	switch( global_scope ) {
		case SCOPE_VERTEX:
			clipboard_vertices_copy();
			break;
		case SCOPE_POLYGON:
			break;
		default:
			break;
	}
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}
void edit_paste_cb( GtkWidget *widget, gpointer data ) {
	switch( global_scope ) {
		case SCOPE_VERTEX:
			clipboard_vertices_paste();
			action_do( the_model, ACTION_MARKER, NULL, NULL, NULL, NULL, NULL, NULL );
			break;
		case SCOPE_POLYGON:
			break;
		default:
			break;
	}
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}
void edit_delete_cb( GtkWidget *widget, gpointer data ) {
	switch( global_scope ) {
		case SCOPE_VERTEX:
			clipboard_vertices_kill();
			action_do( the_model, ACTION_MARKER, NULL, NULL, NULL, NULL, NULL, NULL );
			break;
		case SCOPE_POLYGON:
			clipboard_polys_kill();
			action_do( the_model, ACTION_MARKER, NULL, NULL, NULL, NULL, NULL, NULL );
			break;
		default:
			break;
	}
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}


/*******************************
*
* Show/Hide stuff
*
*******************************/
void menu_hide_verts( GtkWidget *widget, gpointer data ) {
    sel_vert_hide_selected( the_model );
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}

void menu_hide_polys( GtkWidget *widget, gpointer data ) {
    sel_poly_hide_selected( the_model );
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}

void menu_show_verts( GtkWidget *widget, gpointer data ) {
    sel_vert_show_all( the_model );
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}

void menu_show_polys( GtkWidget *widget, gpointer data ) {
    sel_poly_show_all( the_model );
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}

void menu_show_normals( GtkWidget *widget, gpointer data ) {
	view_config.normals_visible = !view_config.normals_visible;
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}



void menu_show_about( GtkWidget *widget, gpointer data ) {
    GtkWidget * label, *button, *frame, *dialog;

    dialog = gtk_dialog_new();
    gtk_widget_set_name( dialog, "About" );
    gtk_container_set_border_width( GTK_CONTAINER( GTK_DIALOG( dialog )->vbox ), 5 );

    label = gtk_label_new( " This is a simple 3D modeler, originally based on\n"
                           " several other GPL'ed programs, including:\n"
                           "   - G3D by Blake Hegerle \n"
                           "        http://condor.stcloudstate.edu/~hebl9901/g3d \n"
                           "        laertes@stab.gemma.com\n"
                           "   - ME3D by Sam Revitch \n"
                           "        http://www.cs.washington.edu/homes/samr7/me3d \n"
                           "        samr7@cs.washington.edu\n"
                           " Note that very little remains of the code from either \n"
						   " of these projects.  Almost all of the old code has been \n"
						   " replaced or removed.\n"
                           " Kludge3d was written by Andrew Sampson (ads4260@rit.edu)\n" );
    gtk_label_set_justify( GTK_LABEL( label ), GTK_JUSTIFY_LEFT );
    gtk_widget_show( label );

    frame = gtk_frame_new( "Creds:" );
    gtk_container_set_border_width( GTK_CONTAINER( frame ), 3 );
    gtk_frame_set_shadow_type( GTK_FRAME( frame ), GTK_SHADOW_OUT );
    gtk_container_add( GTK_CONTAINER( frame ), label );
    gtk_widget_show( frame );

    gtk_box_pack_start( GTK_BOX( GTK_DIALOG( dialog ) ->vbox ),
                        frame, FALSE, FALSE, 5 );

    button = gtk_button_new_with_label( "OK" );
    gtk_widget_show( button );
	g_signal_connect_swapped( G_OBJECT( button ), "clicked",
							G_CALLBACK( gtk_widget_destroy ), dialog );
    gtk_box_pack_start( GTK_BOX( GTK_DIALOG( dialog ) ->action_area ),
                        button, FALSE, FALSE, 0 );

    gtk_widget_show( dialog );
}

GtkWidget *get_menu_bar( GtkWidget *window ) {
    GtkWidget * menubar, *docmenu;
    int nmenu_items = sizeof( menu_items ) / sizeof( menu_items[ 0 ] );
    GtkItemFactory *item_factory;
    GtkAccelGroup *accel_group;

    accel_group = gtk_accel_group_new();

    item_factory = gtk_item_factory_new( GTK_TYPE_MENU_BAR, "<main>",
                                         accel_group );
    gtk_item_factory_create_items( item_factory, nmenu_items, menu_items, NULL );
	gtk_window_add_accel_group ( GTK_WINDOW( window ), accel_group );

    menubar = gtk_item_factory_get_widget( item_factory, "<main>" );
    gtk_widget_show( menubar );
	
	/* populate the Documents menu */
	docmenu = gtk_item_factory_get_widget( item_factory, "/Documents" );
	doc_man_create_menu( docmenu );

//    gtk_widget_set_sensitive( gtk_item_factory_get_widget( item_factory,
//                              "/Preview Mode/Wire Frame" ), FALSE );
//    gtk_widget_set_sensitive( gtk_item_factory_get_widget( item_factory,
//                              "/Preview Mode/Flat" ), FALSE );
//    gtk_widget_set_sensitive( gtk_item_factory_get_widget( item_factory,
//                              "/Preview Mode/Smooth" ), FALSE );

    return menubar;
}





