/* 
 * File:         mesh.h
 * 
 * Description:  header for mesh.c, defines Mesh struct
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 

#ifndef MESH_H
#define MESH_H

#include <glib.h>

#include "geo.h"

Mesh *mesh_new( Model *model );
Mesh *mesh_dup( Mesh * m );
void mesh_delete( Mesh * m );
void mesh_merge( Mesh *m1, Mesh *m2 ) ;

void mesh_set_transform( Mesh *m, Trans *newt );
/*void mesh_set_location( Mesh *m, Vertex *loc );*/
void mesh_set_texture( Mesh *m, Texture *nt );
void mesh_set_texrep( Mesh *m, float x, float y );
void mesh_set_name( Mesh *m, char *name );

void mesh_vertex_add( Mesh *m, Vertex *v );
int mesh_vertex_remove( Mesh *m, Vertex *v );

void mesh_polygon_add( Mesh *m, Poly *p );
int mesh_polygon_remove( Mesh *m, Poly *p );
void mesh_polygon_reparent( Poly *p, Mesh *m ) ;
void mesh_polygon_add_verts_to_mesh( Mesh *m, Poly *p ) ;

int mesh_is_using_vertex( Mesh *m, Vertex *v );
int mesh_has_vertex( Mesh *m, Vertex *v ) ;

#endif
