/* 
 * File:         misc.c
 * 
 * Description:  misc stuff
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>

#include "misc.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif


int array_find( void ** array, int length, void* toFind ) {
	int result = -1;
	int i;
	
	for( i=0; i < length; i++ ) {
		if( array[i] == toFind )
			result = i;
	}
	
	return result;
}

int file_exists( char * name ) {
	struct stat filestat;
	return !((stat( name, &filestat ) == -1) && (errno == ENOENT));
}

