/* 
 * File:         model.h
 * 
 * Description:  header for model.c
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 

#ifndef MODEL_H
#define MODEL_H

#include <glib.h>

#include "geo.h"
#include "texture.h"


#define TOP_GROUP_NAME "World"

struct _Model {
  gchar *name;
  gchar *fname;

  gint fmt_idx;

  GNode *root;
  GNode *current_node;
  Mesh *current_mesh;

  GSList *textures;
  GSList *verts;
  
  int num_verts; /* saves us some time in certain parts of the code */

  GSList *selected_verts;
  GSList *selected_polys;

  GSList *hidden_verts;
  GSList *hidden_polys;
  
	/* undo stuff */
	GList *action_stack;
	GList *action_stack_tail;
	int action_stack_length;
	int undo_enabled;

	/* if there is a polygon in the process of being constructed, 
	   it is stored here in the meantime */
	Poly* partially_completed_poly;

};

/* forward decl in geo.h should take care of this */
/* typedef struct _Model Model; */


/* GLOBALS ************************************************************/

extern Model *the_model;


/* PROTOTYPES *********************************************************/

Model * model_new( void );
void model_delete( Model * );
gboolean model_set_currents( void ) ;
gboolean model_set_currents_m( Model *model ) ;

void model_set_name( Model *model, char *name );
void model_set_filename( Model *model, char *fname );

void model_add_texture( Model *m, Texture *nt );
void model_remove_texture( Model *m, Texture *tt );
void model_remove_all_textures( Model *m );

Texture * model_get_texture_by_filename( Model *m, char* filename );

void model_vertex_add( Model *m, Vertex *v ) ;
void model_vertex_remove( Model *m, Vertex *v ) ;
void model_polygon_remove( Model *m, Poly *t ) ;

void model_flatten( GNode * n, float parentx, float parenty, float parentz );
void model_remove_unused_vertices( Model *model ) ;


#endif
