/* 
 * File:         model_load_save.h
 * 
 * Description:  header for model_load_save.c
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 
#ifndef MODEL_LOAD_SAVE_H
#define MODEL_LOAD_SAVE_H

#include <glib.h>

#include "file_utils.h"
#include "globals.h"
#include "vertex.h"
#include "polygon.h"
#include "model.h"

#define FMT_DELIMITER		'/'

//#define NO_SWAP_YZ
/* 
 * If you don't like the whole "+Z is up" thing, then enable this define.
 *
 * Many editors - like AC3D, Wavefront, etc. - use "+Y is up"... which is 
 * just plain stoopid :)
 */


/* file load/save abstraction */
struct doc_file_fmt {
  gchar *descr;
  gchar *extension;

  gint (* load_file) (struct fu_file *file, Model *doc);
  gint (* save_file) (struct fu_file *file, Model *doc);
  void (* destroy_priv_data) (Model *doc);
};

extern struct doc_file_fmt *fmt_list[];

Model * model_load(const gchar *filename, gint fmt_idx);
gint model_save(Model *doc, const gchar *filename, 
				int overwrite, int *file_exists );
void model_ls_clean_miscdata(Model *doc);

#endif
