/* 
 * File:         notebook.c
 * 
 * Description:  creates the tabbed notebook containing options, etc
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "notebook.h"
#include "globals.h"
#include "view.h"
#include "view_config.h"
#include "tex_man.h"
#include "group_browser.h"
#include "toolbox.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif


/* GLOBALS *************************************************************/
int global_scope = SCOPE_VERTEX;

/* FILE-SCOPE VARS *****************************************************/
GtkWidget * nb_grid_spacing_label;

/* PROTOTYPES **********************************************************/

void nb_set_scope_vertex_cb( GtkWidget *w, GdkEventButton *e, gpointer d ) ;
void nb_set_scope_polygon_cb( GtkWidget *w, GdkEventButton *e, gpointer d ) ;
void nb_set_scope_mesh_cb( GtkWidget *w, GdkEventButton *e, gpointer d ) ;
void nb_toggle_button_cb( GtkWidget *widget, gpointer data ) ;
void nb_change_grid_spacing_cb( GtkWidget *widget, gpointer up_down ) ;
void nb_rendermode_wire_cb( GtkWidget *widget, gpointer data ) ;
void nb_rendermode_flat_cb( GtkWidget *widget, gpointer data ) ;
void nb_rendermode_textured_cb( GtkWidget *widget, gpointer data ) ;
void nb_triangleorder_ccw_cb( GtkWidget *widget, gpointer data ) ;
void nb_triangleorder_cw_cb( GtkWidget *widget, gpointer data ) ;
void nb_triangleorder_all_cb( GtkWidget *widget, gpointer data ) ;
void nb_vertexsize_adj_cb( GtkWidget *widget, gpointer data ) ;
void nb_fov_adj_cb( GtkWidget *widget, gpointer data ) ;
void nb_camheight_adj_cb( GtkWidget *widget, gpointer data ) ;
GtkWidget *create_options( void ) ;
GtkWidget *create_mode_selector( void ) ;


/* CALLBACKS ***********************************************************/

void nb_set_scope_vertex_cb( GtkWidget *w, GdkEventButton *e, gpointer d ) {

    global_scope = SCOPE_VERTEX;
}

void nb_set_scope_polygon_cb( GtkWidget *w, GdkEventButton *e, gpointer d ) {

    global_scope = SCOPE_POLYGON;
}

void nb_set_scope_mesh_cb( GtkWidget *w, GdkEventButton *e, gpointer d ) {

    global_scope = SCOPE_MESH;
}


void nb_toggle_button_cb( GtkWidget *widget, gpointer data ) {

    if( GTK_TOGGLE_BUTTON (widget)->active ) {
        /* If control reaches here, the toggle button is down */

        *((int *)data) = TRUE;
    } else {
        /* If control reaches here, the toggle button is up */

        *((int *)data) = FALSE;
    }
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}

void nb_change_grid_spacing_cb( GtkWidget *widget, gpointer up_down ) {

    char new_label_string[20];
    
    if( GPOINTER_TO_INT(up_down) == 0 ) {
        // down
        view_config.grid_spacing *= 0.10;

    } else if( GPOINTER_TO_INT(up_down) == 1 ) {
        // up
        view_config.grid_spacing *= 10.0;
    }
    
    if( view_config.grid_spacing < 0.01 )
        view_config.grid_spacing = 0.01;
    if( view_config.grid_spacing > 100.0 )
        view_config.grid_spacing = 100.0;

    g_snprintf( new_label_string, 20, "%.3f", view_config.grid_spacing );
    gtk_label_set_text( GTK_LABEL(nb_grid_spacing_label), new_label_string );
    
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}


void nb_rendermode_wire_cb( GtkWidget *widget, gpointer data ) {
    view_set_rendermode( MP_SHOW_WIREFRAME );
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}
void nb_rendermode_flat_cb( GtkWidget *widget, gpointer data ) {
    view_set_rendermode( MP_SHOW_FLAT );
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}
void nb_rendermode_textured_cb( GtkWidget *widget, gpointer data ) {
    view_set_rendermode( MP_SHOW_TEXTURED );
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}


void nb_triangleorder_ccw_cb( GtkWidget *widget, gpointer data ) {
    view_set_triangleorder( MP_TRI_ORDER_CCW );
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}
void nb_triangleorder_cw_cb( GtkWidget *widget, gpointer data ) {
    view_set_triangleorder( MP_TRI_ORDER_CW );
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}
void nb_triangleorder_all_cb( GtkWidget *widget, gpointer data ) {
    view_set_triangleorder( MP_TRI_ORDER_ALL );
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}


void nb_vertexsize_adj_cb( GtkWidget *widget, gpointer data ) {

    if( widget != NULL )
        view_set_vertexsize( GTK_ADJUSTMENT( widget )->value );
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}

void nb_fov_adj_cb( GtkWidget *widget, gpointer data ) {

    if( widget != NULL )
        view_set_fov( GTK_ADJUSTMENT( widget )->value );
	g_signal_emit_by_name( notificationObj, 
		"notify::model-appearance-changed", NULL );
}

void nb_camheight_adj_cb( GtkWidget *widget, gpointer data ) {

    if( widget != NULL )
        view_set_height( GTK_ADJUSTMENT( widget )->value );
}


/* WIDGET-CREATION FUNCS ***********************************************/

GtkWidget *create_options( void ) {

    GtkWidget * options;
    GtkWidget * button;
    GtkWidget * hbox;
    GtkWidget * vbox;
//    GtkWidget * spinb;
//    GtkAdjustment *adj;
    GtkWidget * frame;
    GtkWidget * gsframe;
//    GtkWidget * hsep;
    GtkAdjustment * hadjustment;
    GtkWidget * hscale;
	GtkWidget * label;

    options = gtk_vbox_new( FALSE, 5 );
    gtk_container_set_border_width( GTK_CONTAINER(options), 5 );
    
    // GRID STUFF ////////////////////////////////////////////////
    frame = gtk_frame_new( "Grid options" );
    vbox = gtk_vbox_new( FALSE, 0 );

    button = gtk_check_button_new_with_label( "show grid" );
    g_signal_connect( G_OBJECT( button ), "clicked",
                        G_CALLBACK( nb_toggle_button_cb ), (gpointer)(&(view_config.grid_visible)) );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( button ), TRUE );
    gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 0 );
    gtk_widget_show( button );

/*
    button = gtk_check_button_new_with_label( "snap to grid" );
    g_signal_connect (G_OBJECT( button ), "clicked",
                        G_CALLBACK( nb_toggle_button_cb ), (gpointer)(&grid_snap) );
    gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 0 );
    gtk_widget_show( button );
*/

    // grid spacing ///////////////////////////
    gsframe = gtk_frame_new( "grid spacing" );
    gtk_frame_set_shadow_type( GTK_FRAME( gsframe ), GTK_SHADOW_NONE );
    hbox = gtk_hbox_new( FALSE, 0 );

    button = gtk_button_new_with_label( "-" );
    g_signal_connect (G_OBJECT (button), "clicked",
                        G_CALLBACK( nb_change_grid_spacing_cb ), 0 );
    gtk_widget_show( button );
    gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, FALSE, 0 );

    nb_grid_spacing_label = gtk_label_new( "1" );
    gtk_widget_show( nb_grid_spacing_label );
    gtk_box_pack_start( GTK_BOX( hbox ), nb_grid_spacing_label, TRUE, FALSE, 0 );
    
    button = gtk_button_new_with_label( "+" );
    g_signal_connect (G_OBJECT (button), "clicked",
                        G_CALLBACK( nb_change_grid_spacing_cb ), 
                        (gpointer *) 1 );
    gtk_widget_show( button );
    gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, FALSE, 0 );

    gtk_widget_show( hbox );
    gtk_container_add( GTK_CONTAINER( gsframe ), hbox );
    gtk_box_pack_start( GTK_BOX( vbox ), gsframe, FALSE, FALSE, 0 );
    gtk_widget_show( gsframe );
    
    gtk_widget_show( vbox );
    gtk_container_add( GTK_CONTAINER( frame ), vbox );
    gtk_box_pack_start( GTK_BOX( options ), frame, FALSE, FALSE, 0 );
    gtk_widget_show( frame );

//    hsep = gtk_hseparator_new();
//    gtk_box_pack_start( GTK_BOX( options ), hsep, FALSE, FALSE, 0 );
//    gtk_widget_show( hsep );

    // origin marker ////////////////////////
    button = gtk_check_button_new_with_label( "show origin" );
    g_signal_connect( G_OBJECT( button ), "clicked",
                        G_CALLBACK( nb_toggle_button_cb ), (gpointer)(&(view_config.origin_visible)) );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( button ), TRUE );
    gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 0 );
    gtk_widget_show( button );


    // RENDERING MODE RADIO BUTTONS
    frame = gtk_frame_new( "Rendering mode" );
    vbox = gtk_vbox_new( FALSE, 0 );

    button = gtk_radio_button_new_with_label( NULL, "wireframe" );
    g_signal_connect (G_OBJECT( button ), "clicked",
                        G_CALLBACK( nb_rendermode_wire_cb ), NULL );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( button ), TRUE );
    gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 0 );
    gtk_widget_show( button );

    button = gtk_radio_button_new_with_label( 
                 gtk_radio_button_get_group( GTK_RADIO_BUTTON( button ) ), 
                 "flat shaded" );
    g_signal_connect (G_OBJECT( button ), "clicked",
                        G_CALLBACK( nb_rendermode_flat_cb ), NULL );
    gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 0 );
    gtk_widget_show( button );

    button = gtk_radio_button_new_with_label( 
                 gtk_radio_button_get_group( GTK_RADIO_BUTTON( button ) ), 
                 "textured" );
    g_signal_connect (G_OBJECT( button ), "clicked",
                        G_CALLBACK( nb_rendermode_textured_cb ), NULL );
    gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 0 );
    gtk_widget_show( button );

    gtk_widget_show( vbox );
    gtk_container_add( GTK_CONTAINER( frame ), vbox );
    gtk_box_pack_start( GTK_BOX( options ), frame, FALSE, FALSE, 0 );
    gtk_widget_show( frame );


    // TRIANGLE CULLING RADIO BUTTONS
    frame = gtk_frame_new( "Triangle direction" );
    vbox = gtk_vbox_new( FALSE, 0 );

    button = gtk_radio_button_new_with_label( NULL, "ccw" );
    g_signal_connect (G_OBJECT( button ), "clicked",
                        G_CALLBACK( nb_triangleorder_ccw_cb ), NULL );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( button ), TRUE );
    gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 0 );
    gtk_widget_show( button );

    button = gtk_radio_button_new_with_label( 
                 gtk_radio_button_get_group( GTK_RADIO_BUTTON( button ) ), 
                 "cw" );
    g_signal_connect (G_OBJECT( button ), "clicked",
                        G_CALLBACK( nb_triangleorder_cw_cb ), NULL );
    gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 0 );
    gtk_widget_show( button );

    button = gtk_radio_button_new_with_label( 
                 gtk_radio_button_get_group( GTK_RADIO_BUTTON( button ) ), 
                 "all" );
    g_signal_connect (G_OBJECT( button ), "clicked",
                        G_CALLBACK( nb_triangleorder_all_cb ), NULL );
    gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 0 );
    gtk_widget_show( button );

    gtk_widget_show( vbox );
    gtk_container_add( GTK_CONTAINER( frame ), vbox );
    gtk_box_pack_start( GTK_BOX( options ), frame, FALSE, FALSE, 0 );
    gtk_widget_show( frame );



    // VERTEX SIZE STUFF
    frame = gtk_frame_new( "Vertex size" );
    vbox = gtk_vbox_new( FALSE, 0 );

#if 0
    button = gtk_radio_button_new_with_label( NULL, "off" );
    g_signal_connect (G_OBJECT( button ), "clicked",
                        G_CALLBACK( vertexsize_off_cb ), NULL );
    gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 0 );
    gtk_widget_show( button );

    button = gtk_radio_button_new_with_label( 
                 gtk_radio_button_get_group( GTK_RADIO_BUTTON( button ) ), 
                 "normal" );
    g_signal_connect (G_OBJECT( button ), "clicked",
                        G_CALLBACK( vertexsize_normal_cb ), NULL );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( button ), TRUE );
    gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 0 );
    gtk_widget_show( button );

    button = gtk_radio_button_new_with_label( 
                 gtk_radio_button_get_group( GTK_RADIO_BUTTON( button ) ), 
                 "enlarged" );
    g_signal_connect (G_OBJECT( button ), "clicked",
                        G_CALLBACK( vertexsize_enlarged_cb ), NULL );
    gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 0 );
    gtk_widget_show( button );
#endif

    hadjustment = GTK_ADJUSTMENT( gtk_adjustment_new( view_config.vertex_rad, 
                                                      0.001, 1, 0.001, 0.01, 0.01 ) );
    g_signal_connect ( G_OBJECT ( hadjustment ), "value_changed",
                         G_CALLBACK ( nb_vertexsize_adj_cb ), NULL );
    hscale = gtk_hscale_new( hadjustment );
    gtk_range_set_update_policy( GTK_RANGE( hscale ), GTK_UPDATE_DISCONTINUOUS );
    gtk_scale_set_digits( GTK_SCALE( hscale ), 3 );
    /* gtk developers: why does *this* affect the granularity of the 
	scale widget?  are you all on crack? */
    gtk_widget_show( hscale );
    gtk_box_pack_start( GTK_BOX( vbox ), hscale, FALSE, FALSE, 0 );

    button = gtk_check_button_new_with_label( "Show vertices" );
    g_signal_connect (G_OBJECT( button ), "clicked",
                        G_CALLBACK( nb_toggle_button_cb ), (gpointer)(&view_config.vertices_visible) );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( button ), TRUE );
    gtk_box_pack_start( GTK_BOX( vbox ), button, FALSE, FALSE, 0 );
    gtk_widget_show( button );

    gtk_widget_show( vbox );
    gtk_container_add( GTK_CONTAINER( frame ), vbox );
    gtk_box_pack_start( GTK_BOX( options ), frame, FALSE, FALSE, 0 );
    gtk_widget_show( frame );



    /* 3d VIEW STUFF */
    frame = gtk_frame_new( "3d View Options" );
    vbox = gtk_vbox_new( FALSE, 0 );

	/* FIELD OF VIEW */
	label = gtk_label_new( "Field Of View (degrees)" );
	gtk_widget_show( label );
	gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 0 );

    hadjustment = GTK_ADJUSTMENT( gtk_adjustment_new( view_config.fov, 
                                                      10, 140, 0.01, 0.01, 0.01 ) );
    g_signal_connect ( G_OBJECT ( hadjustment ), "value_changed",
                         G_CALLBACK ( nb_fov_adj_cb ), NULL );
    hscale = gtk_hscale_new( hadjustment );
    gtk_range_set_update_policy( GTK_RANGE( hscale ), GTK_UPDATE_DISCONTINUOUS );
    gtk_scale_set_digits( GTK_SCALE( hscale ), 2 );
    gtk_widget_show( hscale );
    gtk_box_pack_start( GTK_BOX( vbox ), hscale, FALSE, FALSE, 0 );

	/* CAMERA HEIGHT */
	label = gtk_label_new( "Camera-point Height" );
	gtk_widget_show( label );
	gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 0 );

    hadjustment = GTK_ADJUSTMENT( gtk_adjustment_new( 0.0, 
													  -10.0, 10.0, 
													  0.01, 0.01, 0.01 ) );
    g_signal_connect ( G_OBJECT ( hadjustment ), "value_changed",
                         G_CALLBACK ( nb_camheight_adj_cb ), NULL );
    hscale = gtk_hscale_new( hadjustment );
    gtk_range_set_update_policy( GTK_RANGE( hscale ), GTK_UPDATE_CONTINUOUS );
    gtk_scale_set_digits( GTK_SCALE( hscale ), 2 );
    gtk_widget_show( hscale );
    gtk_box_pack_start( GTK_BOX( vbox ), hscale, FALSE, FALSE, 0 );



    gtk_widget_show( vbox );
    gtk_container_add( GTK_CONTAINER( frame ), vbox );
    gtk_box_pack_start( GTK_BOX( options ), frame, FALSE, FALSE, 0 );
    gtk_widget_show( frame );



    gtk_widget_show( options );
    
    return options;
}


GtkWidget *create_mode_selector( void ) {

    GtkWidget *hbox, *button;
	GtkTooltips *tips;

	tips = gtk_tooltips_new();

    hbox = gtk_hbox_new( FALSE, 5 );
    button = gtk_radio_button_new_with_label( NULL, "Vertex Mode" );
    g_signal_connect (G_OBJECT( button ), "clicked",
                        G_CALLBACK( nb_set_scope_vertex_cb ), 
                        (gpointer)( SCOPE_VERTEX ) );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( button ), TRUE );
	gtk_tooltips_set_tip( tips, button,
						  "Puts kludge3d in Vertex Mode", NULL );
    gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
    gtk_widget_show( button );

    button = gtk_radio_button_new_with_label( 
                 gtk_radio_button_get_group( GTK_RADIO_BUTTON( button ) ), 
                 "Polygon Mode" );
    g_signal_connect (G_OBJECT( button ), "clicked",
                        G_CALLBACK( nb_set_scope_polygon_cb ), 
                        (gpointer)( SCOPE_POLYGON ) );
	gtk_tooltips_set_tip( tips, button,
						  "Puts kludge3d in Polygon Mode", NULL );
    gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
    gtk_widget_show( button );

#if 0
    button = gtk_radio_button_new_with_label( 
                 gtk_radio_button_get_group( GTK_RADIO_BUTTON( button ) ), 
                 "Mesh" );
    g_signal_connect (G_OBJECT( button ), "clicked",
                        G_CALLBACK( nb_set_scope_mesh_cb ), 
                        (gpointer)( SCOPE_MESH ) );
    gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, FALSE, 0 );
    gtk_widget_show( button );
// for now...
    gtk_widget_set_sensitive( button, FALSE );
#endif

	gtk_tooltips_enable( tips );

    gtk_widget_show( hbox );
    return hbox;
}


GtkWidget *create_notebook( void ) {
    GtkWidget * notebook;
    GtkWidget * vbox;
    GtkWidget * options;
    GtkWidget * textures;
    GtkWidget * groups;
    GtkWidget * tools;
    
    GtkWidget * label;
    
    
    vbox = gtk_vbox_new( FALSE, 0 );
    notebook = gtk_notebook_new(  );

    groups = create_group_browser();
    textures = create_tex_manager();
    options = create_options();
    tools = create_toolbox();
    
    gtk_box_pack_start( GTK_BOX( vbox ), create_mode_selector(), 
                        FALSE, FALSE, 0 );
    
    label = gtk_label_new( "Groups" );
    gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), groups, label );
    gtk_widget_show( label );

    label = gtk_label_new( "Textures" );
    gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), textures, label );
    gtk_widget_show( label );

    label = gtk_label_new( "Tools" );
    gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), tools, label );
    gtk_widget_show( label );

    label = gtk_label_new( "Options" );
    gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), options, label );
    gtk_widget_show( label );


    gtk_widget_show( notebook );
    gtk_box_pack_start( GTK_BOX( vbox ), notebook, TRUE, TRUE, 0 );

    gtk_widget_show( vbox );

    return vbox;
}


