/* 
 * File:         polygon.h
 * 
 * Description:  header file for polygon.c
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 
#ifndef POLYGON_H
#define POLYGON_H

#include "geo.h"
#include "mesh.h"
#include "globals.h"
#include "vertex.h"
#include "texture.h"

/* the maximum number of vertices allowed in a polygon */
#define POLY_MAX_VERTS	10

Poly * poly_new( void );
void poly_delete( Poly *p );
void poly_remove( Poly *p ) ;
Poly * poly_dup( Poly * );
void poly_add_vertex( Poly *p, Vertex *v ) ;
void poly_add_vertex_nth( Poly *p, Vertex *v, int vert_index ) ;
void poly_remove_vertex( Poly *p, Vertex *v ) ;
void poly_replace_vertex( Poly *p, Vertex *v, int vert_index ) ;

int poly_has_vertex( Poly *p, Vertex *v ) ;

void poly_reverse_winding( Poly *p );
void poly_find_normal( Poly * p ) ;
void poly_find_center_point( float *v, Poly * p ) ;

GSList * polys_get_verts_unique( GSList *polys ) ;
GSList * polys_get_verts( GSList *polys ) ;

int polys_count_vertex_usage( GSList *polys, Vertex *v ) ;
int polys_count_edge_usage( GSList *polys, Vertex *v1, Vertex *v2 ) ;
int poly_has_edge( Poly *p, Vertex *v1, Vertex *v2 ) ;

TexCoord * poly_get_texcoord( Poly *p, Vertex *v ) ;
void texcoord_change_values( TexCoord *tc, float u, float v );

#endif
