/* 
 * File:         prefs.h
 * 
 * Description:  header file for prefs.c
 * 
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */
 
#ifndef PREFS_H
#define PREFS_H

#include <glib.h>

typedef enum {
	PREF_TYPE_BOOL,
	PREF_TYPE_INT,
	PREF_TYPE_FLOAT,
	PREF_TYPE_VECTOR,
	PREF_TYPE_STRING,
	
	PREF_TYPE_UNKNOWN
} PrefDataType;


typedef struct _Pref Pref;
struct _Pref {
	char * name;
	
	PrefDataType type;
	int data_int;
	float data_float;
	float data_vector[3];
	char *data_string;
};

/* GLOBALS ******************************************************************/

extern GSList *prefs_list;


/* PROTOTYPES ***************************************************************/

void prefs_load( void ) ;
void prefs_save( void ) ;

void pref_set_bool( char * name, int data ) ;
int pref_get_bool( char * name, int default_value ) ;
void pref_set_int( char * name, int data ) ;
int pref_get_int( char * name, int default_value ) ;
void pref_set_float( char * name, float data ) ;
float pref_get_float( char * name, float default_value ) ;
void pref_set_vector( char * name, float * data ) ;
float * pref_get_vector( char * name, float * default_value ) ;
void pref_set_string( char * name, char * data ) ;
char * pref_get_string( char * name, char * default_value ) ;


#endif
