/* 
 * File:         primitive.c
 * 
 * Description:  handles reference counting for primitives (verts & polys)
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */

#include <stdlib.h>

#include "primitive.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif

#ifdef PRIM_DEBUG
int prim_debug_counter = 15;
Primitive* special_prim = NULL;
#include "polygon.h"
#endif

void primitive_ref( Primitive *p ) {
	if( p == NULL )
		return;

	p->ref_count++;

#ifdef PRIM_DEBUG
if( p == special_prim ) {
	printf( "(ref)   primitive %x has ref count %i\n", (unsigned int)special_prim, special_prim->ref_count );
}
#endif

}

void primitive_unref( Primitive *p ) {
	if( p == NULL )
		return;
	
	p->ref_count--;
	
#ifdef PRIM_DEBUG
if( p == special_prim ) {
	printf( "(unref) primitive %x has ref count %i\n", (unsigned int)special_prim, special_prim->ref_count );
}
#endif

	if( p->ref_count <= 0 ) {
		if( p->delete_func )
			p->delete_func( p );
#ifdef PRIM_DEBUG
printf( "called delete func on primitive %x \n", (unsigned int)p );
#endif
	}
}

void primitive_set_delete_cb( 
	Primitive *p,
	void (* delete_func)( Primitive * ) ) 
{
	if( p == NULL )
		return;

#ifdef PRIM_DEBUG
if( delete_func == poly_delete ) {
prim_debug_counter--;
if( prim_debug_counter <= 0 && special_prim == NULL ) {
	special_prim = p;
}
}
#endif

	p->delete_func = delete_func;
}

