#ifndef PYWRAPPER_H 
#define PYWRAPPER_H 

#ifdef SWIG
%style before
#endif

/* "Registers" a Python function with kludge3d.  This info will be used to 
set up buttons and dialogs for the function, so that it can be called 
without having to type the stuff in by hand.  You don't need to call this 
directly; instead, you should use 'register_function', which is called like 
this: register_function( 'modulename', function )
You should use __name__ instead of 'modulename', though.
*/
void register_func_with_kludge3d( char *modulename, char *funcname, char *helpstring, char *argstring ) ;

/* Inserts a new vertex into the current mesh.
 Returns a pointer to the newly-created vertex.
*/
Vertex *vert_insert(double x, double y, double z);

/* Moves verts along the vector defined by <x,y,z>
*/
void translate_verts( GSList *verts, double x, double y, double z ) ;

/* Moves currently selected verts along the vector defined by <x,y,z>
*/
void translate_sel_verts( double x, double y, double z ) ;

/* Rotates verts around coordinate axes
Rotations occur around the x-axis first, then y, then z.
The angle is in degrees.
*/
void rotate_verts( GSList *verts, double x, double y, double z ) ;

/* Rotates currently selected verts around coordinate axes
Rotations occur around the x-axis first, then y, then z.
The angle is in degrees.
*/
void rotate_sel_verts( double x, double y, double z ) ;

/* Rotates verts around specified point px,py,pz
Rotations occur around the x-axis first, then y, then z.
The angle is in degrees.
*/
void rotate_verts_about_point(GSList *verts, 
						double x, double y, double z,
                        double px, double py, double pz) ;

/* Rotates currently selected verts around specified point px,py,pz
Rotations occur around the x-axis first, then y, then z.
The angle is in degrees.
*/
void rotate_sel_verts_about_point(
						double x, double y, double z,
                        double px, double py, double pz) ;

/* Scales verts about their midpoint by factor X,Y,Z.  To scale uniformly, 
use the same value for all 3 factor arguments.
*/
void scale_verts( GSList *verts, 
				double factorX, double factorY, double factorZ ) ;

/* Scales the selected verts about their midpoint by factor X,Y,Z.  To scale 
uniformly, use the same value for all 3 factor arguments.
*/
void scale_sel_verts( 
				double factorX, double factorY, double factorZ ) ;

/* Returns the selected vertices
*/
GSList * get_selected_verts( void ) ;

/* Selects the verts in the list
*/
void select_verts( GSList *verts ) ;

/* Unselects all of the vertices.
*/
void unselect_verts_all( void ) ;

/* Returns a list of all verts within the box specified by min xyz, max xyz.
Each element of min xyz should be less than its corresponding 
element in max xyz.
*/
GSList *get_verts_box( double min_x, double min_y, double min_z,
                       double max_x, double max_y, double max_z ) ;

/* Returns a list of all verts within the box specified by min xyz, max xyz.
Each element of min xyz should be less than its corresponding 
element in max xyz.
*/
GSList *get_verts_sphere( double x, double y, double z,
                          double radius ) ;

/* Returns a list of the vertices used by the given polygons.  No vertex will 
appear twice in the resulting list.
*/
GSList * get_verts_in_polys( GSList *polys ) ;

/* Inserts a new poly into the current mesh.  This func will search for 
verts near the specified verts, and (if such verts are not found)
will create new verts as needed.
*/
Poly * poly_insert( GSList * verts ) ;

/* DEPRECATED Inserts a new 3-sided poly into the current mesh, using the 
3 given coordinates as vertex locations.  Vertices are created as needed.
*/
Poly * poly_insert_tri( 
	double p1x, double p1y, double p1z, 
	double p2x, double p2y, double p2z, 
	double p3x, double p3y, double p3z ) ;

/* DEPRECATED Inserts a new 4-sided poly into the current mesh, using the 
4 given coordinates as vertex locations.  Vertices are created as needed.
*/
Poly * poly_insert_quad( 
	double p1x, double p1y, double p1z, 
	double p2x, double p2y, double p2z, 
	double p3x, double p3y, double p3z, 
	double p4x, double p4y, double p4z ) ;

/* Returns the selected polys
*/
GSList * get_selected_polys( void ) ;

/* Extrudes the polys in the list.  If 'connected' is true, polys will remain 
connected after being extruded; otherwise, polys will be extruded 
individually.  Returns the list of newly-created polys, with the members 
of 'polys' at the head of the list.
*/
GSList * polys_extrude( GSList *polys, int connected ) ;

/* Returns the normal of the poly.  It is called like so: 
tuple = get_poly_normal( p, None ) */
void get_poly_normal( Poly * p, float out[3] ) ;

#endif
