%module pykludge3d
%{
#include <glib.h>
#include "geo.h"
#include "vertex.h"
#include "tools.h"
#include "pywrapper.h"
%}

%typemap(python,in) GSList * {
	
	/* Check if is a list */
	if(PyList_Check($source)) {
		int size = PyList_Size($source);
		int i = 0;
		$target = NULL;
		for(i = 0; i < size; i++) {
			PyObject *o = PyList_GetItem($source,i);
			if( PyString_Check(o) ) {
				void *ptr = NULL;
				if( SWIG_GetPtr( PyString_AsString(PyList_GetItem($source,i)), &ptr, NULL ) == NULL ) {
					$target = g_slist_append( $target, ptr );
				} else {
					PyErr_SetString(PyExc_TypeError,"list must contain pointers encoded as strings");
					g_slist_free((GSList *) $target);
					return NULL;
				}
			} else {
				PyErr_SetString(PyExc_TypeError,"list must contain strings");
				g_slist_free((GSList *) $target);
				return NULL;
			}
		}
	} else {
		PyErr_SetString(PyExc_TypeError,"not a list");
		return NULL;
	}
}

%typemap(python,freearg) GSList * {
	g_slist_free((GSList *) $source);
}

%typemap(python,out) GSList * {
	GSList *l;
	int i;
	$target = PyList_New( g_slist_length( $source ) );
	for( l = $source, i = 0; l; l = l->next ) {
		char buf[256];
		char * type;
		switch( ((Primitive*)l->data)->type ) {
			case PRIM_TYPE_VERTEX:
				type = "_Vertex_p";
				break;
			case PRIM_TYPE_POLY:
				type = "_Poly_p";
				break;
			default:
				type = "";
				break;
		}
		SWIG_MakePtr( buf, l->data, type );
		PyList_SetItem( $target, i++, PyString_FromString( buf ) );
	}
	g_slist_free( $source );
}


%typemap(python,in) float out[3] {
  static float outresult[3];
  $target = &outresult[0];
}   

%typemap(python,argout) float out[3] {
	int i;
	PyObject *o;

	o = PyTuple_New(3);
	for (i = 0; i < 3; i++) {
		PyTuple_SetItem(o,i,PyFloat_FromDouble((double)($source[i])));
	}
	if (!$target) {
		$target = o;
	} else if ($target == Py_None) {
		Py_DECREF(Py_None);
		$target = o;
	} else {
		if (!PyList_Check($target)) {
			PyObject *o2 = $target;
			$target = PyList_New(0);
			PyList_Append($target,o2);
			Py_XDECREF(o2);
		}
		PyList_Append($target,o);
		Py_XDECREF(o);
	}
}

%include pywrapper.h
