/*
 * FILE : pywrapper_wrap.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Patch 5)
 * 
 * Portions Copyright (c) 1995-1998
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : PYTHON */

#define SWIGPYTHON
#include <string.h>
#include <stdlib.h>
/***********************************************************************
 * $Header: /home/andy/src/kludge3d/src/RCS/pywrapper_wrap.c,v 1.9 2003/12/01 18:22:50 andy Exp andy $
 * swig_lib/python/python.cfg
 *
 * This file contains coded needed to add variable linking to the
 * Python interpreter.   C variables are added as a new kind of Python
 * datatype.
 *
 * Also contains supporting code for building python under Windows
 * and things like that.
 *
 * $Log: pywrapper_wrap.c,v $
 * Revision 1.9  2003/12/01 18:22:50  andy
 * added extrude and get-normal funcs; removed the double-asterisks
 * from the comments; now returns the newly-created poly for the
 * insert-poly funcs
 *
 ************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif
#include "Python.h"
#ifdef __cplusplus
}
#endif

/* Definitions for Windows/Unix exporting */
#if defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a,b) __declspec(dllexport) a b
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a,b) a _export b
#	else
#	    define SWIGEXPORT(a,b) a b
#	endif
#   endif
#else
#   define SWIGEXPORT(a,b) a b
#endif

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif

typedef struct {
  char  *name;
  PyObject *(*get_attr)(void);
  int (*set_attr)(PyObject *);
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar **vars;
  int      nvars;
  int      maxvars;
} swig_varlinkobject;

/* ----------------------------------------------------------------------
   swig_varlink_repr()

   Function for python repr method
   ---------------------------------------------------------------------- */

static PyObject *
swig_varlink_repr(swig_varlinkobject *v)
{
  v = v;
  return PyString_FromString("<Global variables>");
}

/* ---------------------------------------------------------------------
   swig_varlink_print()

   Print out all of the global variable names
   --------------------------------------------------------------------- */

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags)
{

  int i = 0;
  flags = flags;
  fprintf(fp,"Global variables { ");
  while (v->vars[i]) {
    fprintf(fp,"%s", v->vars[i]->name);
    i++;
    if (v->vars[i]) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

/* --------------------------------------------------------------------
   swig_varlink_getattr
 
   This function gets the value of a variable and returns it as a
   PyObject.   In our case, we'll be looking at the datatype and
   converting into a number or string
   -------------------------------------------------------------------- */

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n)
{
  int i = 0;
  char temp[128];

  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->get_attr)();
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return NULL;
}

/* -------------------------------------------------------------------
   swig_varlink_setattr()

   This function sets the value of a variable.
   ------------------------------------------------------------------- */

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p)
{
  char temp[128];
  int i = 0;
  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->set_attr)(p);
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return 1;
}

statichere PyTypeObject varlinktype = {
/*  PyObject_HEAD_INIT(&PyType_Type)  Note : This doesn't work on some machines */
  PyObject_HEAD_INIT(0)              
  0,
  "varlink",                          /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */

SWIGSTATIC PyObject *
SWIG_newvarlink(void)
{
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  /*  _Py_NewReference(result);  Does not seem to be necessary */
  result->nvars = 0;
  result->maxvars = 64;
  result->vars = (swig_globalvar **) malloc(64*sizeof(swig_globalvar *));
  result->vars[0] = 0;
  result->ob_refcnt = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGSTATIC void
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p))
{
  swig_varlinkobject *v;
  v= (swig_varlinkobject *) p;
	
  if (v->nvars >= v->maxvars -1) {
    v->maxvars = 2*v->maxvars;
    v->vars = (swig_globalvar **) realloc(v->vars,v->maxvars*sizeof(swig_globalvar *));
    if (v->vars == NULL) {
      fprintf(stderr,"SWIG : Fatal error in initializing Python module.\n");
      exit(1);
    }
  }
  v->vars[v->nvars] = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  v->vars[v->nvars]->name = (char *) malloc(strlen(name)+1);
  strcpy(v->vars[v->nvars]->name,name);
  v->vars[v->nvars]->get_attr = get_attr;
  v->vars[v->nvars]->set_attr = set_attr;
  v->nvars++;
  v->vars[v->nvars] = 0;
}



/*****************************************************************************
 * $Header: /home/andy/src/kludge3d/src/RCS/pywrapper_wrap.c,v 1.9 2003/12/01 18:22:50 andy Exp andy $
 *
 * swigptr.swg
 *
 * This file contains supporting code for the SWIG run-time type checking
 * mechanism.  The following functions are available :
 *
 * SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *));
 *
 *      Registers a new type-mapping with the type-checker.  origtype is the
 *      original datatype and newtype is an equivalent type.  cast is optional
 *      pointer to a function to cast pointer values between types (this
 *      is typically used to cast pointers from derived classes to base classes in C++)
 *      
 * SWIG_MakePtr(char *buffer, void *ptr, char *typestring);
 *     
 *      Makes a pointer string from a pointer and typestring.  The result is returned
 *      in buffer which is assumed to hold enough space for the result.
 *
 * char * SWIG_GetPtr(char *buffer, void **ptr, char *type)
 *
 *      Gets a pointer value from a string.  If there is a type-mismatch, returns
 *      a character string to the received type.  On success, returns NULL.
 *
 *
 * You can remap these functions by making a file called "swigptr.swg" in
 * your the same directory as the interface file you are wrapping.
 *
 * These functions are normally declared static, but this file can be
 * can be used in a multi-module environment by redefining the symbol
 * SWIGSTATIC.
 *****************************************************************************/

#include <stdlib.h>

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif


/* SWIG pointer structure */

typedef struct SwigPtrType {
  char               *name;               /* Datatype name                  */
  int                 len;                /* Length (used for optimization) */
  void               *(*cast)(void *);    /* Pointer casting function       */
  struct SwigPtrType *next;               /* Linked list pointer            */
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

/* Some variables  */

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
                                       /* This value may be adjusted dynamically */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static int SwigStart[256];             /* Starting positions of types            */

/* Pointer table */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];  
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}

/* Register a new datatype with the type-checker */

SWIGSTATIC 
void SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {

  int i;
  SwigPtrType *t = 0,*t1;

  /* Allocate the pointer table if necessary */

  if (!SwigPtrTable) {     
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  /* Grow the table */
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc((char *) SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(t->name);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }

  /* Check for existing entry */

  while (t->next) {
    if ((strcmp(t->name,newtype) == 0)) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  
  /* Now place entry (in sorted order) */

  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(t1->name);
  t1->cast = cast;
  t1->next = 0;            
  t->next = t1;           
  SwigPtrSort = 0;
}

/* Make a pointer value string */

SWIGSTATIC 
void SWIG_MakePtr(char *_c, const void *_ptr, char *type) {
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;    /* Note : a 64-bit hex number = 16 digits */
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
    }
    *_r = '_';
    while (_r >= _result)
      *(_c++) = *(_r--);
  } else {
    strcpy (_c, "NULL");
  }
  if (_ptr)
    strcpy (_c, type);
}

/* Define for backwards compatibility */

#define _swig_make_hex   SWIG_MakePtr 

/* Function for getting a pointer value */

SWIGSTATIC 
char *SWIG_GetPtr(char *_c, void **ptr, char *_t)
{
  unsigned long _p;
  char temp_type[256];
  char *name;
  int  i, len;
  SwigPtrType *sp,*tp;
  SwigCacheType *cache;
  int  start, end;
  _p = 0;

  /* Pointer values must start with leading underscore */
  if (*_c == '_') {
      _c++;
      /* Extract hex value from pointer */
      while (*_c) {
	  if ((*_c >= '0') && (*_c <= '9'))
	    _p = (_p << 4) + (*_c - '0');
	  else if ((*_c >= 'a') && (*_c <= 'f'))
	    _p = (_p << 4) + ((*_c - 'a') + 10);
	  else
	    break;
	  _c++;
      }

      if (_t) {
	if (strcmp(_t,_c)) { 
	  if (!SwigPtrSort) {
	    qsort((void *) SwigPtrTable, SwigPtrN, sizeof(SwigPtrType), swigsort); 
	    for (i = 0; i < 256; i++) {
	      SwigStart[i] = SwigPtrN;
	    }
	    for (i = SwigPtrN-1; i >= 0; i--) {
	      SwigStart[(int) (SwigPtrTable[i].name[1])] = i;
	    }
	    for (i = 255; i >= 1; i--) {
	      if (SwigStart[i-1] > SwigStart[i])
		SwigStart[i-1] = SwigStart[i];
	    }
	    SwigPtrSort = 1;
	    for (i = 0; i < SWIG_CACHESIZE; i++)  
	      SwigCache[i].stat = 0;
	  }
	  
	  /* First check cache for matches.  Uses last cache value as starting point */
	  cache = &SwigCache[SwigLastCache];
	  for (i = 0; i < SWIG_CACHESIZE; i++) {
	    if (cache->stat) {
	      if (strcmp(_t,cache->name) == 0) {
		if (strcmp(_c,cache->mapped) == 0) {
		  cache->stat++;
		  *ptr = (void *) _p;
		  if (cache->tp->cast) *ptr = (*(cache->tp->cast))(*ptr);
		  return (char *) 0;
		}
	      }
	    }
	    SwigLastCache = (SwigLastCache+1) & SWIG_CACHEMASK;
	    if (!SwigLastCache) cache = SwigCache;
	    else cache++;
	  }
	  /* We have a type mismatch.  Will have to look through our type
	     mapping table to figure out whether or not we can accept this datatype */

	  start = SwigStart[(int) _t[1]];
	  end = SwigStart[(int) _t[1]+1];
	  sp = &SwigPtrTable[start];
	  while (start < end) {
	    if (swigcmp(_t,sp) == 0) break;
	    sp++;
	    start++;
	  }
	  if (start >= end) sp = 0;
	  /* Try to find a match for this */
	  if (sp) {
	    while (swigcmp(_t,sp) == 0) {
	      name = sp->name;
	      len = sp->len;
	      tp = sp->next;
	      /* Try to find entry for our given datatype */
	      while(tp) {
		if (tp->len >= 255) {
		  return _c;
		}
		strcpy(temp_type,tp->name);
		strncat(temp_type,_t+len,255-tp->len);
		if (strcmp(_c,temp_type) == 0) {
		  
		  strcpy(SwigCache[SwigCacheIndex].mapped,_c);
		  strcpy(SwigCache[SwigCacheIndex].name,_t);
		  SwigCache[SwigCacheIndex].stat = 1;
		  SwigCache[SwigCacheIndex].tp = tp;
		  SwigCacheIndex = SwigCacheIndex & SWIG_CACHEMASK;
		  
		  /* Get pointer value */
		  *ptr = (void *) _p;
		  if (tp->cast) *ptr = (*(tp->cast))(*ptr);
		  return (char *) 0;
		}
		tp = tp->next;
	      }
	      sp++;
	      /* Hmmm. Didn't find it this time */
	    }
	  }
	  /* Didn't find any sort of match for this data.  
	     Get the pointer value and return the received type */
	  *ptr = (void *) _p;
	  return _c;
	} else {
	  /* Found a match on the first try.  Return pointer value */
	  *ptr = (void *) _p;
	  return (char *) 0;
	}
      } else {
	/* No type specified.  Good luck */
	*ptr = (void *) _p;
	return (char *) 0;
      }
  } else {
    if (strcmp (_c, "NULL") == 0) {
	*ptr = (void *) 0;
	return (char *) 0;
    }
    *ptr = (void *) 0;	
    return _c;
  }
}

/* Compatibility mode */

#define _swig_get_hex  SWIG_GetPtr

#define SWIG_init    initpykludge3d

#define SWIG_name    "pykludge3d"

#include <glib.h>
#include "geo.h"
#include "vertex.h"
#include "tools.h"
#include "pywrapper.h"
static PyObject *_wrap_register_func_with_kludge3d(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;
    char * _arg1;
    char * _arg2;
    char * _arg3;

    self = self;
    if(!PyArg_ParseTuple(args,"ssss:register_func_with_kludge3d",&_arg0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    register_func_with_kludge3d(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_vert_insert(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Vertex * _result;
    double  _arg0;
    double  _arg1;
    double  _arg2;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"ddd:vert_insert",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    _result = (Vertex *)vert_insert(_arg0,_arg1,_arg2);
    SWIG_MakePtr(_ptemp, (char *) _result,"_Vertex_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_translate_verts(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GSList * _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddd:translate_verts",&_obj0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
{
	
	/* Check if is a list */
	if(PyList_Check(_obj0)) {
		int size = PyList_Size(_obj0);
		int i = 0;
		_arg0 = NULL;
		for(i = 0; i < size; i++) {
			PyObject *o = PyList_GetItem(_obj0,i);
			if( PyString_Check(o) ) {
				void *ptr = NULL;
				if( SWIG_GetPtr( PyString_AsString(PyList_GetItem(_obj0,i)), &ptr, NULL ) == NULL ) {
					_arg0 = g_slist_append( _arg0, ptr );
				} else {
					PyErr_SetString(PyExc_TypeError,"list must contain pointers encoded as strings");
					g_slist_free((GSList *) _arg0);
					return NULL;
				}
			} else {
				PyErr_SetString(PyExc_TypeError,"list must contain strings");
				g_slist_free((GSList *) _arg0);
				return NULL;
			}
		}
	} else {
		PyErr_SetString(PyExc_TypeError,"not a list");
		return NULL;
	}
}
    translate_verts(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
	g_slist_free((GSList *) _arg0);
}
    return _resultobj;
}

static PyObject *_wrap_translate_sel_verts(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _arg0;
    double  _arg1;
    double  _arg2;

    self = self;
    if(!PyArg_ParseTuple(args,"ddd:translate_sel_verts",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    translate_sel_verts(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_rotate_verts(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GSList * _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddd:rotate_verts",&_obj0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
{
	
	/* Check if is a list */
	if(PyList_Check(_obj0)) {
		int size = PyList_Size(_obj0);
		int i = 0;
		_arg0 = NULL;
		for(i = 0; i < size; i++) {
			PyObject *o = PyList_GetItem(_obj0,i);
			if( PyString_Check(o) ) {
				void *ptr = NULL;
				if( SWIG_GetPtr( PyString_AsString(PyList_GetItem(_obj0,i)), &ptr, NULL ) == NULL ) {
					_arg0 = g_slist_append( _arg0, ptr );
				} else {
					PyErr_SetString(PyExc_TypeError,"list must contain pointers encoded as strings");
					g_slist_free((GSList *) _arg0);
					return NULL;
				}
			} else {
				PyErr_SetString(PyExc_TypeError,"list must contain strings");
				g_slist_free((GSList *) _arg0);
				return NULL;
			}
		}
	} else {
		PyErr_SetString(PyExc_TypeError,"not a list");
		return NULL;
	}
}
    rotate_verts(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
	g_slist_free((GSList *) _arg0);
}
    return _resultobj;
}

static PyObject *_wrap_rotate_sel_verts(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _arg0;
    double  _arg1;
    double  _arg2;

    self = self;
    if(!PyArg_ParseTuple(args,"ddd:rotate_sel_verts",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    rotate_sel_verts(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_rotate_verts_about_point(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GSList * _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;
    double  _arg6;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddddd:rotate_verts_about_point",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6)) 
        return NULL;
{
	
	/* Check if is a list */
	if(PyList_Check(_obj0)) {
		int size = PyList_Size(_obj0);
		int i = 0;
		_arg0 = NULL;
		for(i = 0; i < size; i++) {
			PyObject *o = PyList_GetItem(_obj0,i);
			if( PyString_Check(o) ) {
				void *ptr = NULL;
				if( SWIG_GetPtr( PyString_AsString(PyList_GetItem(_obj0,i)), &ptr, NULL ) == NULL ) {
					_arg0 = g_slist_append( _arg0, ptr );
				} else {
					PyErr_SetString(PyExc_TypeError,"list must contain pointers encoded as strings");
					g_slist_free((GSList *) _arg0);
					return NULL;
				}
			} else {
				PyErr_SetString(PyExc_TypeError,"list must contain strings");
				g_slist_free((GSList *) _arg0);
				return NULL;
			}
		}
	} else {
		PyErr_SetString(PyExc_TypeError,"not a list");
		return NULL;
	}
}
    rotate_verts_about_point(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
	g_slist_free((GSList *) _arg0);
}
    return _resultobj;
}

static PyObject *_wrap_rotate_sel_verts_about_point(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;

    self = self;
    if(!PyArg_ParseTuple(args,"dddddd:rotate_sel_verts_about_point",&_arg0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5)) 
        return NULL;
    rotate_sel_verts_about_point(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_scale_verts(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GSList * _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oddd:scale_verts",&_obj0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
{
	
	/* Check if is a list */
	if(PyList_Check(_obj0)) {
		int size = PyList_Size(_obj0);
		int i = 0;
		_arg0 = NULL;
		for(i = 0; i < size; i++) {
			PyObject *o = PyList_GetItem(_obj0,i);
			if( PyString_Check(o) ) {
				void *ptr = NULL;
				if( SWIG_GetPtr( PyString_AsString(PyList_GetItem(_obj0,i)), &ptr, NULL ) == NULL ) {
					_arg0 = g_slist_append( _arg0, ptr );
				} else {
					PyErr_SetString(PyExc_TypeError,"list must contain pointers encoded as strings");
					g_slist_free((GSList *) _arg0);
					return NULL;
				}
			} else {
				PyErr_SetString(PyExc_TypeError,"list must contain strings");
				g_slist_free((GSList *) _arg0);
				return NULL;
			}
		}
	} else {
		PyErr_SetString(PyExc_TypeError,"not a list");
		return NULL;
	}
}
    scale_verts(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
	g_slist_free((GSList *) _arg0);
}
    return _resultobj;
}

static PyObject *_wrap_scale_sel_verts(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _arg0;
    double  _arg1;
    double  _arg2;

    self = self;
    if(!PyArg_ParseTuple(args,"ddd:scale_sel_verts",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    scale_sel_verts(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_get_selected_verts(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GSList * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":get_selected_verts")) 
        return NULL;
    _result = (GSList *)get_selected_verts();
{
	GSList *l;
	int i;
	_resultobj = PyList_New( g_slist_length( _result ) );
	for( l = _result, i = 0; l; l = l->next ) {
		char buf[256];
		char * type;
		switch( ((Primitive*)l->data)->type ) {
			case PRIM_TYPE_VERTEX:
				type = "_Vertex_p";
				break;
			case PRIM_TYPE_POLY:
				type = "_Poly_p";
				break;
			default:
				type = "";
				break;
		}
		SWIG_MakePtr( buf, l->data, type );
		PyList_SetItem( _resultobj, i++, PyString_FromString( buf ) );
	}
	g_slist_free( _result );
}
    return _resultobj;
}

static PyObject *_wrap_select_verts(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GSList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:select_verts",&_obj0)) 
        return NULL;
{
	
	/* Check if is a list */
	if(PyList_Check(_obj0)) {
		int size = PyList_Size(_obj0);
		int i = 0;
		_arg0 = NULL;
		for(i = 0; i < size; i++) {
			PyObject *o = PyList_GetItem(_obj0,i);
			if( PyString_Check(o) ) {
				void *ptr = NULL;
				if( SWIG_GetPtr( PyString_AsString(PyList_GetItem(_obj0,i)), &ptr, NULL ) == NULL ) {
					_arg0 = g_slist_append( _arg0, ptr );
				} else {
					PyErr_SetString(PyExc_TypeError,"list must contain pointers encoded as strings");
					g_slist_free((GSList *) _arg0);
					return NULL;
				}
			} else {
				PyErr_SetString(PyExc_TypeError,"list must contain strings");
				g_slist_free((GSList *) _arg0);
				return NULL;
			}
		}
	} else {
		PyErr_SetString(PyExc_TypeError,"not a list");
		return NULL;
	}
}
    select_verts(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
	g_slist_free((GSList *) _arg0);
}
    return _resultobj;
}

static PyObject *_wrap_unselect_verts_all(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":unselect_verts_all")) 
        return NULL;
    unselect_verts_all();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_get_verts_box(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GSList * _result;
    double  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;

    self = self;
    if(!PyArg_ParseTuple(args,"dddddd:get_verts_box",&_arg0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5)) 
        return NULL;
    _result = (GSList *)get_verts_box(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
{
	GSList *l;
	int i;
	_resultobj = PyList_New( g_slist_length( _result ) );
	for( l = _result, i = 0; l; l = l->next ) {
		char buf[256];
		char * type;
		switch( ((Primitive*)l->data)->type ) {
			case PRIM_TYPE_VERTEX:
				type = "_Vertex_p";
				break;
			case PRIM_TYPE_POLY:
				type = "_Poly_p";
				break;
			default:
				type = "";
				break;
		}
		SWIG_MakePtr( buf, l->data, type );
		PyList_SetItem( _resultobj, i++, PyString_FromString( buf ) );
	}
	g_slist_free( _result );
}
    return _resultobj;
}

static PyObject *_wrap_get_verts_sphere(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GSList * _result;
    double  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;

    self = self;
    if(!PyArg_ParseTuple(args,"dddd:get_verts_sphere",&_arg0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    _result = (GSList *)get_verts_sphere(_arg0,_arg1,_arg2,_arg3);
{
	GSList *l;
	int i;
	_resultobj = PyList_New( g_slist_length( _result ) );
	for( l = _result, i = 0; l; l = l->next ) {
		char buf[256];
		char * type;
		switch( ((Primitive*)l->data)->type ) {
			case PRIM_TYPE_VERTEX:
				type = "_Vertex_p";
				break;
			case PRIM_TYPE_POLY:
				type = "_Poly_p";
				break;
			default:
				type = "";
				break;
		}
		SWIG_MakePtr( buf, l->data, type );
		PyList_SetItem( _resultobj, i++, PyString_FromString( buf ) );
	}
	g_slist_free( _result );
}
    return _resultobj;
}

static PyObject *_wrap_get_verts_in_polys(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GSList * _result;
    GSList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:get_verts_in_polys",&_obj0)) 
        return NULL;
{
	
	/* Check if is a list */
	if(PyList_Check(_obj0)) {
		int size = PyList_Size(_obj0);
		int i = 0;
		_arg0 = NULL;
		for(i = 0; i < size; i++) {
			PyObject *o = PyList_GetItem(_obj0,i);
			if( PyString_Check(o) ) {
				void *ptr = NULL;
				if( SWIG_GetPtr( PyString_AsString(PyList_GetItem(_obj0,i)), &ptr, NULL ) == NULL ) {
					_arg0 = g_slist_append( _arg0, ptr );
				} else {
					PyErr_SetString(PyExc_TypeError,"list must contain pointers encoded as strings");
					g_slist_free((GSList *) _arg0);
					return NULL;
				}
			} else {
				PyErr_SetString(PyExc_TypeError,"list must contain strings");
				g_slist_free((GSList *) _arg0);
				return NULL;
			}
		}
	} else {
		PyErr_SetString(PyExc_TypeError,"not a list");
		return NULL;
	}
}
    _result = (GSList *)get_verts_in_polys(_arg0);
{
	GSList *l;
	int i;
	_resultobj = PyList_New( g_slist_length( _result ) );
	for( l = _result, i = 0; l; l = l->next ) {
		char buf[256];
		char * type;
		switch( ((Primitive*)l->data)->type ) {
			case PRIM_TYPE_VERTEX:
				type = "_Vertex_p";
				break;
			case PRIM_TYPE_POLY:
				type = "_Poly_p";
				break;
			default:
				type = "";
				break;
		}
		SWIG_MakePtr( buf, l->data, type );
		PyList_SetItem( _resultobj, i++, PyString_FromString( buf ) );
	}
	g_slist_free( _result );
}
{
	g_slist_free((GSList *) _arg0);
}
    return _resultobj;
}

static PyObject *_wrap_poly_insert(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Poly * _result;
    GSList * _arg0;
    PyObject * _obj0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:poly_insert",&_obj0)) 
        return NULL;
{
	
	/* Check if is a list */
	if(PyList_Check(_obj0)) {
		int size = PyList_Size(_obj0);
		int i = 0;
		_arg0 = NULL;
		for(i = 0; i < size; i++) {
			PyObject *o = PyList_GetItem(_obj0,i);
			if( PyString_Check(o) ) {
				void *ptr = NULL;
				if( SWIG_GetPtr( PyString_AsString(PyList_GetItem(_obj0,i)), &ptr, NULL ) == NULL ) {
					_arg0 = g_slist_append( _arg0, ptr );
				} else {
					PyErr_SetString(PyExc_TypeError,"list must contain pointers encoded as strings");
					g_slist_free((GSList *) _arg0);
					return NULL;
				}
			} else {
				PyErr_SetString(PyExc_TypeError,"list must contain strings");
				g_slist_free((GSList *) _arg0);
				return NULL;
			}
		}
	} else {
		PyErr_SetString(PyExc_TypeError,"not a list");
		return NULL;
	}
}
    _result = (Poly *)poly_insert(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_Poly_p");
    _resultobj = Py_BuildValue("s",_ptemp);
{
	g_slist_free((GSList *) _arg0);
}
    return _resultobj;
}

static PyObject *_wrap_poly_insert_tri(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Poly * _result;
    double  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;
    double  _arg6;
    double  _arg7;
    double  _arg8;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"ddddddddd:poly_insert_tri",&_arg0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6,&_arg7,&_arg8)) 
        return NULL;
    _result = (Poly *)poly_insert_tri(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7,_arg8);
    SWIG_MakePtr(_ptemp, (char *) _result,"_Poly_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_poly_insert_quad(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Poly * _result;
    double  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;
    double  _arg6;
    double  _arg7;
    double  _arg8;
    double  _arg9;
    double  _arg10;
    double  _arg11;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"dddddddddddd:poly_insert_quad",&_arg0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6,&_arg7,&_arg8,&_arg9,&_arg10,&_arg11)) 
        return NULL;
    _result = (Poly *)poly_insert_quad(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7,_arg8,_arg9,_arg10,_arg11);
    SWIG_MakePtr(_ptemp, (char *) _result,"_Poly_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_get_selected_polys(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GSList * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":get_selected_polys")) 
        return NULL;
    _result = (GSList *)get_selected_polys();
{
	GSList *l;
	int i;
	_resultobj = PyList_New( g_slist_length( _result ) );
	for( l = _result, i = 0; l; l = l->next ) {
		char buf[256];
		char * type;
		switch( ((Primitive*)l->data)->type ) {
			case PRIM_TYPE_VERTEX:
				type = "_Vertex_p";
				break;
			case PRIM_TYPE_POLY:
				type = "_Poly_p";
				break;
			default:
				type = "";
				break;
		}
		SWIG_MakePtr( buf, l->data, type );
		PyList_SetItem( _resultobj, i++, PyString_FromString( buf ) );
	}
	g_slist_free( _result );
}
    return _resultobj;
}

static PyObject *_wrap_polys_extrude(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GSList * _result;
    GSList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:polys_extrude",&_obj0,&_arg1)) 
        return NULL;
{
	
	/* Check if is a list */
	if(PyList_Check(_obj0)) {
		int size = PyList_Size(_obj0);
		int i = 0;
		_arg0 = NULL;
		for(i = 0; i < size; i++) {
			PyObject *o = PyList_GetItem(_obj0,i);
			if( PyString_Check(o) ) {
				void *ptr = NULL;
				if( SWIG_GetPtr( PyString_AsString(PyList_GetItem(_obj0,i)), &ptr, NULL ) == NULL ) {
					_arg0 = g_slist_append( _arg0, ptr );
				} else {
					PyErr_SetString(PyExc_TypeError,"list must contain pointers encoded as strings");
					g_slist_free((GSList *) _arg0);
					return NULL;
				}
			} else {
				PyErr_SetString(PyExc_TypeError,"list must contain strings");
				g_slist_free((GSList *) _arg0);
				return NULL;
			}
		}
	} else {
		PyErr_SetString(PyExc_TypeError,"not a list");
		return NULL;
	}
}
    _result = (GSList *)polys_extrude(_arg0,_arg1);
{
	GSList *l;
	int i;
	_resultobj = PyList_New( g_slist_length( _result ) );
	for( l = _result, i = 0; l; l = l->next ) {
		char buf[256];
		char * type;
		switch( ((Primitive*)l->data)->type ) {
			case PRIM_TYPE_VERTEX:
				type = "_Vertex_p";
				break;
			case PRIM_TYPE_POLY:
				type = "_Poly_p";
				break;
			default:
				type = "";
				break;
		}
		SWIG_MakePtr( buf, l->data, type );
		PyList_SetItem( _resultobj, i++, PyString_FromString( buf ) );
	}
	g_slist_free( _result );
}
{
	g_slist_free((GSList *) _arg0);
}
    return _resultobj;
}

static PyObject *_wrap_get_poly_normal(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    Poly * _arg0;
    float * _arg1;
    char * _argc0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sO:get_poly_normal",&_argc0,&_obj1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_Poly_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of get_poly_normal. Expected _Poly_p.");
        return NULL;
        }
    }
{
  static float outresult[3];
  _arg1 = &outresult[0];
}
    get_poly_normal(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
	int i;
	PyObject *o;

	o = PyTuple_New(3);
	for (i = 0; i < 3; i++) {
		PyTuple_SetItem(o,i,PyFloat_FromDouble((double)(_arg1[i])));
	}
	if (!_resultobj) {
		_resultobj = o;
	} else if (_resultobj == Py_None) {
		Py_DECREF(Py_None);
		_resultobj = o;
	} else {
		if (!PyList_Check(_resultobj)) {
			PyObject *o2 = _resultobj;
			_resultobj = PyList_New(0);
			PyList_Append(_resultobj,o2);
			Py_XDECREF(o2);
		}
		PyList_Append(_resultobj,o);
		Py_XDECREF(o);
	}
}
    return _resultobj;
}

static PyMethodDef pykludge3dMethods[] = {
	 { "get_poly_normal", _wrap_get_poly_normal, 1 },
	 { "polys_extrude", _wrap_polys_extrude, 1 },
	 { "get_selected_polys", _wrap_get_selected_polys, 1 },
	 { "poly_insert_quad", _wrap_poly_insert_quad, 1 },
	 { "poly_insert_tri", _wrap_poly_insert_tri, 1 },
	 { "poly_insert", _wrap_poly_insert, 1 },
	 { "get_verts_in_polys", _wrap_get_verts_in_polys, 1 },
	 { "get_verts_sphere", _wrap_get_verts_sphere, 1 },
	 { "get_verts_box", _wrap_get_verts_box, 1 },
	 { "unselect_verts_all", _wrap_unselect_verts_all, 1 },
	 { "select_verts", _wrap_select_verts, 1 },
	 { "get_selected_verts", _wrap_get_selected_verts, 1 },
	 { "scale_sel_verts", _wrap_scale_sel_verts, 1 },
	 { "scale_verts", _wrap_scale_verts, 1 },
	 { "rotate_sel_verts_about_point", _wrap_rotate_sel_verts_about_point, 1 },
	 { "rotate_verts_about_point", _wrap_rotate_verts_about_point, 1 },
	 { "rotate_sel_verts", _wrap_rotate_sel_verts, 1 },
	 { "rotate_verts", _wrap_rotate_verts, 1 },
	 { "translate_sel_verts", _wrap_translate_sel_verts, 1 },
	 { "translate_verts", _wrap_translate_verts, 1 },
	 { "vert_insert", _wrap_vert_insert, 1 },
	 { "register_func_with_kludge3d", _wrap_register_func_with_kludge3d, 1 },
	 { NULL, NULL }
};
static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void,initpykludge3d)() {
	 PyObject *m, *d;
	 SWIG_globals = SWIG_newvarlink();
	 m = Py_InitModule("pykludge3d", pykludge3dMethods);
	 d = PyModule_GetDict(m);
/*
 * These are the pointer type-equivalency mappings. 
 * (Used by the SWIG pointer type-checker).
 */
	 SWIG_RegisterMapping("_signed_long","_long",0);
	 SWIG_RegisterMapping("_long","_unsigned_long",0);
	 SWIG_RegisterMapping("_long","_signed_long",0);
	 SWIG_RegisterMapping("_unsigned_long","_long",0);
	 SWIG_RegisterMapping("_signed_int","_int",0);
	 SWIG_RegisterMapping("_unsigned_short","_short",0);
	 SWIG_RegisterMapping("_signed_short","_short",0);
	 SWIG_RegisterMapping("_unsigned_int","_int",0);
	 SWIG_RegisterMapping("_short","_unsigned_short",0);
	 SWIG_RegisterMapping("_short","_signed_short",0);
	 SWIG_RegisterMapping("_int","_unsigned_int",0);
	 SWIG_RegisterMapping("_int","_signed_int",0);
}
