/* 
 * File:		 rollup.c
 * 
 * Description:  provides "tool roll up" functionality, as seen in many of the 
 *               popular 3d and drawing packages.  Tool buttons can be 
 *               organized into "pages", which can be hidden or shown by 
 *               clicking on the button at the head of each page.  It is 
 *               recommended that you wrap the rollup widget in a scrolled win.
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "rollup.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif

/* PROTOTYPES ***********************************************************/

void rollup_switch_arrow_cb( GtkButton *button, gpointer data ) ;
void rollup_toggle_frame_cb( GtkButton *button, gpointer data ) ;


/* FUNCS ****************************************************************/

GtkWidget * rollup_new( void ) {
	return gtk_vbox_new( FALSE, 0 );
}


void rollup_append_page( 
	GtkWidget *rollup, GtkWidget *child, char *labelstr, int expanded ) 
{
	GtkWidget *frame, *label, *button, *hbox, *arrow;
	
	if( rollup == NULL || child == NULL ) return;
	
	button = gtk_button_new();
	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( button ), hbox );

	/* 'expanded' indicator on button */
	arrow = gtk_arrow_new( GTK_ARROW_DOWN, GTK_SHADOW_NONE );
	gtk_box_pack_start( GTK_BOX( hbox ), arrow, FALSE, FALSE, 0 );
	
	/* label on button */
	label = gtk_label_new( labelstr );
	gtk_box_pack_start( GTK_BOX( hbox ), label, TRUE, TRUE, 0 );
	
	frame = gtk_frame_new( NULL );
	gtk_container_add( GTK_CONTAINER( frame ), child );
	
	gtk_widget_show_all( button );
	gtk_widget_show_all( frame );
	gtk_box_pack_start( GTK_BOX( rollup ), button, FALSE, FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( rollup ), frame, FALSE, FALSE, 0 );
	
	/* signal handlers for the button */
	g_signal_connect( G_OBJECT( button ), "clicked", 
						G_CALLBACK( rollup_switch_arrow_cb ), arrow );
	g_signal_connect( G_OBJECT( button ), "clicked", 
						G_CALLBACK( rollup_toggle_frame_cb ), frame );
	
	if( !expanded ) {
		rollup_switch_arrow_cb( GTK_BUTTON(button), arrow );
		rollup_toggle_frame_cb( GTK_BUTTON(button), frame );
	}
}


/* CALLBACKS ************************************************************/

void rollup_switch_arrow_cb( GtkButton *button, gpointer data ) {
	GtkArrow *arrow = GTK_ARROW( data );
	gtk_arrow_set( arrow, 
		arrow->arrow_type == GTK_ARROW_DOWN ? GTK_ARROW_RIGHT : GTK_ARROW_DOWN, 
		GTK_SHADOW_NONE );
}


void rollup_toggle_frame_cb( GtkButton *button, gpointer data ) {
	GtkWidget *widget = GTK_WIDGET( data );
	if( GTK_WIDGET_VISIBLE( widget ) ) {
		gtk_widget_hide( widget );
	} else {
		gtk_widget_show( widget );
	}
}


