/* 
 * File:		 scriptbox.c
 * 
 * Description:  
 * 
 * This source code is part of kludge3d, and is released under the 
 * GNU General Public License.
 * 
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "config.h"
#include "scriptbox.h"
#include "gui.h"
#include "globals.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif

#ifdef USE_PYTHON
#include <Python.h>
#endif


struct _SBEntry {
	char *funcname;
	char *helpstring;
	GSList *args;
};
typedef struct _SBEntry SBEntry;


/* FILE-SCOPE VARS ******************************************************/

GSList *script_list = NULL;
GtkWidget *scriptbox = NULL;


/* PROTOTYPES ***********************************************************/

gboolean scriptbox_cleanup( gpointer data ) ;
void scriptbox_free_func( SBEntry *script ) ;
void scriptbox_add_button( SBEntry *script ) ;
void scriptbox_show_dialog( GtkWidget *widget, gpointer data ) ;


/* FUNCS ****************************************************************/

GtkWidget * create_scriptbox( void ) {
	GSList *l;
	scriptbox = gtk_vbox_new( FALSE, 0 );
	
	for( l = script_list; l; l = l->next ) {
		scriptbox_add_button( (SBEntry *)l->data );
	}
	
	gtk_widget_show_all( scriptbox );
	return scriptbox;
}


gboolean scriptbox_cleanup( gpointer data ) {
	GSList *l;
	
	for( l = script_list; l; l = l->next ) {
		scriptbox_free_func( (SBEntry *)l->data );
	}
	g_slist_free( script_list );
	script_list = NULL;

	return FALSE;
}


void scriptbox_add_func( char *funcname, char *helpstring, char *arglist ) {
	static int first_time = TRUE;
	SBEntry *script = (SBEntry *)malloc( sizeof(SBEntry) );
	memset( script, 0, sizeof(SBEntry) );
	script->funcname = strdup( funcname );
	script->helpstring = helpstring != NULL ? strdup(helpstring) : strdup("");
	{
	char *arglistcopy = strdup( arglist );
	char *aptr;
	aptr = strtok( arglistcopy, " " );
	while( aptr ) {
		script->args = g_slist_append( script->args, strdup( aptr ) );
		aptr = strtok( NULL, " " );
	}
	free( arglistcopy );
	}
	
	script_list = g_slist_append( script_list, script );
	
	scriptbox_add_button( script );
	
	if( first_time ) {
		g_signal_connect( notificationObj, "notify::exit", 
			G_CALLBACK(scriptbox_cleanup), NULL );
		first_time = FALSE;
	}
}


void scriptbox_free_func( SBEntry *script ) {
	GSList *l;
	if( script->funcname )
		free( script->funcname );
	if( script->helpstring )
		free( script->helpstring );
	for( l = script->args; l; l = l->next ) {
		free( l->data );
	}
	g_slist_free( script->args );
	memset( script, 0, sizeof(SBEntry) );
	free( script );
}


void scriptbox_add_button( SBEntry *script ) {
	GtkWidget *button;
	
	if( scriptbox == NULL ) return;
	
	button = gtk_button_new_with_label( script->funcname );

	g_signal_connect( G_OBJECT( button ), "clicked",
		G_CALLBACK( scriptbox_show_dialog ), script );

	gtk_box_pack_start( GTK_BOX( scriptbox ), button, FALSE, FALSE, 0 );
	gtk_widget_show( button );
}


void scriptbox_show_dialog( GtkWidget *widget, gpointer data ) {
	SBEntry *script = (SBEntry *)data;
	GtkWidget *dialog;
	GtkWidget *label, *hbox, *entry;
	gint dlg_response;
	GSList *l, *entries = NULL;
	
	dialog = gtk_dialog_new_with_buttons ("Run Script",
										  GTK_WINDOW( TopLevelWindow ),
										  GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL,
										  GTK_STOCK_OK,
										  GTK_RESPONSE_OK,
										  GTK_STOCK_CANCEL,
										  GTK_RESPONSE_CANCEL,
										  NULL);
	
	label = gtk_label_new( script->funcname );
	gtk_box_pack_start( GTK_BOX(GTK_DIALOG(dialog)->vbox), label, FALSE, FALSE, 10 );

	label = gtk_label_new( script->helpstring );
	gtk_box_pack_start( GTK_BOX(GTK_DIALOG(dialog)->vbox), label, FALSE, FALSE, 10 );
	
	/* for each argument, create an entry */
	for( l = script->args; l; l = l->next ) {
		hbox = gtk_hbox_new( TRUE, 10 );
		label = gtk_label_new( (char*)l->data );
		entry = gtk_entry_new();
		entries = g_slist_append( entries, entry );
		gtk_box_pack_start( GTK_BOX( hbox ), label, TRUE, TRUE, 0 );
		gtk_box_pack_start( GTK_BOX( hbox ), entry, TRUE, TRUE, 0 );
		gtk_box_pack_start( GTK_BOX(GTK_DIALOG(dialog)->vbox), hbox, FALSE, FALSE, 10 );
	}
	
	gtk_widget_show_all( GTK_DIALOG(dialog)->vbox );
	
	/* RUN DIALOG ******************************/
	dlg_response = gtk_dialog_run( GTK_DIALOG (dialog) );
	switch( dlg_response ) {
		case GTK_RESPONSE_OK:
			{
			char cmd_string[512] = {'\0'};
			const gchar * text;
			
			strncat( cmd_string, script->funcname, 511 );
			strncat( cmd_string, "( ", 511 );
			for( l = entries; l; l = l->next ) {
				text = gtk_entry_get_text( GTK_ENTRY( l->data ) );
				strncat( cmd_string, text, 511 );
				if( l->next )
					strncat( cmd_string, ", ", 511 );
			}
			strncat( cmd_string, " )", 511 );
#ifdef USE_PYTHON
			PyRun_SimpleString( cmd_string );
#else
			printf( "%s\n", cmd_string );
#endif
			}
			break;
		default:
			break;
	}
	
	gtk_widget_destroy( dialog );
	g_slist_free( entries );
}


